/*
 * Decompiled with CFR 0.152.
 */
package org.act.sim;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.act.cat.CatConfig;
import org.act.cat.CatEngine;
import org.act.cat.CatEngineStandard;
import org.act.cat.CatInputStandard;
import org.act.cat.ExposureControlData;
import org.act.cat.ExposureControlFunctions;
import org.act.cat.ExposureControlType;
import org.act.cat.ExposureItemUsage;
import org.act.cat.ItemScores;
import org.act.cat.PassageOrItemEligibilityOverall;
import org.act.cat.ThetaRange;
import org.act.sim.AbstractCatSimulation;
import org.act.sim.AbstractCatSimulationTask;
import org.act.sim.CatSimulationTaskStandard;
import org.act.sim.SimOutput;
import org.act.sim.SimulationFunctions;
import org.act.sol.InfeasibleTestConfigException;
import org.act.testdef.Item;
import org.act.testdef.TestConfig;
import org.act.util.ProbDistribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatSimulationStandard
extends AbstractCatSimulation {
    private static final Logger LOGGER = LoggerFactory.getLogger(CatSimulationStandard.class);

    public CatSimulationStandard(String simName, int examineeNum, ProbDistribution thetaDistribution, TestConfig testConfig, CatConfig catConfig, Boolean isGenSimResult) {
        super(simName, examineeNum, thetaDistribution, testConfig, catConfig, isGenSimResult);
    }

    @Override
    public List<SimOutput> runSim() throws IOException, InfeasibleTestConfigException {
        double[] trueThetas = this.genTrueThetas();
        CatEngine catEngine = CatEngineStandard.INSTANCE;
        ArrayList<SimOutput> simOutputs = new ArrayList<SimOutput>();
        Map<ThetaRange, Map<String, ExposureItemUsage>> exposureItemUsageRangeMap = this.initializeItemUsage();
        for (int examineeIndex = 0; examineeIndex < this.getExamineeNum(); ++examineeIndex) {
            LOGGER.info("Simulation starts for examinee #{}", (Object)(examineeIndex + 1));
            double trueTheta = trueThetas[examineeIndex];
            String studentId = examineeIndex + "";
            PassageOrItemEligibilityOverall eligibility = ExposureControlFunctions.buildPassageOrItemEligibilityOverall(this.getCatConfig(), this.getTestConfig(), exposureItemUsageRangeMap);
            CatInputStandard catInput = new CatInputStandard.Builder().catConfig(this.getCatConfig()).testConfig(this.getTestConfig()).completedCount(0).adaptiveStage(0).studentId(studentId).itemsAdmin(new ArrayList<String>()).itemScores(new ItemScores(new int[0], new double[0])).administeredPassageIndexSequence(new ArrayList<Integer>()).exposureControlData(new ExposureControlData()).passageOrItemEligibilityOverall(eligibility).itemsToAdminister(new ArrayList<String>()).shadowTest(new ArrayList<String>()).previousTheta(0.0).previousThetaSe(1.0).build();
            CatSimulationTaskStandard studentSimTask = new CatSimulationTaskStandard(studentId, trueTheta, catEngine, catInput, eligibility);
            SimOutput simOutput = ((AbstractCatSimulationTask)studentSimTask).runSimTask(this.isGenSimResult());
            int itemIdColIndex = this.getTestConfig().getItemPoolTable().columnIndex(Item.ColumnName.ITEM_ID.getColName());
            List<String> itemIds = this.getTestConfig().getItemPoolTable().columns().get(itemIdColIndex);
            if (this.getCatConfig().exposureControlConfig().getType().equals((Object)ExposureControlType.ITEM)) {
                ExposureControlFunctions.updateItemUsage(exposureItemUsageRangeMap, simOutput.getPassageOrItemEligibilityAtThetaRangeList().get(simOutput.getPassageOrItemEligibilityAtThetaRangeList().size() - 2), simOutput.getItemsAdministered(), itemIds);
                if (examineeIndex == this.getExamineeNum() - 1) {
                    Map<ThetaRange, Map<String, Double>> itemExposureRates = SimulationFunctions.calItemExposureRates(exposureItemUsageRangeMap, this.getExamineeNum());
                    simOutput.setItemExposureRates(itemExposureRates);
                }
            }
            if (this.isGenSimResult()) {
                simOutputs.add(simOutput);
            }
            LOGGER.info("Simulation ends for examinee #{}", (Object)(examineeIndex + 1));
        }
        return simOutputs;
    }

    private Map<ThetaRange, Map<String, ExposureItemUsage>> initializeItemUsage() {
        HashMap<ThetaRange, Map<String, ExposureItemUsage>> exposureItemUsageRangeMap = new HashMap<ThetaRange, Map<String, ExposureItemUsage>>();
        ThetaRange thetaRange = new ThetaRange(-8.0, 8.0);
        int itemIdColIndex = this.getTestConfig().getItemPoolTable().columnIndex(Item.ColumnName.ITEM_ID.getColName());
        List<String> itemIds = this.getTestConfig().getItemPoolTable().columns().get(itemIdColIndex);
        HashMap<String, ExposureItemUsage> exposureItemUsageMap = new HashMap<String, ExposureItemUsage>();
        for (String itemId : itemIds) {
            exposureItemUsageMap.put(itemId, new ExposureItemUsage(itemId, thetaRange, 0.0, 0.0));
        }
        exposureItemUsageRangeMap.put(thetaRange, exposureItemUsageMap);
        return exposureItemUsageRangeMap;
    }
}

