% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSAGA-modules.R
\name{rsaga.import.gdal}
\alias{rsaga.import.gdal}
\title{Import Grid Files to SAGA grid format using GDAL}
\usage{
rsaga.import.gdal(in.grid, out.grid, env = rsaga.env(), ...)
}
\arguments{
\item{in.grid}{file name of a grid in a format supported by GDAL}

\item{out.grid}{output SAGA grid file name; defaults to \code{in.grid} with
the file extension being removed; file extension should not be specified,
it defaults to \code{.sgrd}}

\item{env}{RSAGA geoprocessing environment created by \code{\link[=rsaga.env]{rsaga.env()}}}

\item{...}{additional arguments to be passed to \code{rsaga.geoprocessor}}
}
\description{
These functions provide simple interfaces for reading and writing grids
from/to ASCII grids and Rd files. Grids are stored in matrices, their headers
in lists.
}
\details{
The GDAL Raster Import module of SAGA imports grid data from various
file formats using the Geospatial Data Abstraction Library (GDAL) by Frank
Warmerdam. GDAL Versions are specific to SAGA versions:
\itemize{
\item SAGA 2.0.7 - 2.0.8: GDAL v.1.8.0
\item SAGA 2.1.0 - 2.1.1: GDAL v.1.10.0
\item SAGA 2.1.2 - 2.2.0: GDAL v.1.11.0
\item SAGA 2.2.1 - 2.2.3: GDAL v.2.1.0 dev
More information is available at \url{http://www.gdal.org/}.
}

If \code{in.grid} has more than one band (e.g. RGB GEOTIFF), then output
grids with file names of the form \eqn{in.grid{\_}01.sgrd}{in.grid_01.sgrd},
\eqn{in.grid{\_}02.sgrd}{in.grid_02.sgrd} etc. are written, one for each
band.

The following raster formats are currently supported. Last updated for SAGA
GIS 2.2.3; for a list for a specific SAGA GIS version call
\code{rsaga.html.help("io_gdal","GDAL: Import Raster", env = rsaga.env(path="SAGA_Version_to_Test"))}
\itemize{
\item BAG - Bathymetry Attributed Grid
\item ECW - ERDAS Compressed Wavelets (SDK 3.x)
\item JP2ECW - ERDAS JPEG2000 (SDK 3.x)
\item FITS - Flexible Image Transport System
\item GMT - GMT NetCDF Grid Format
\item HDF4 - Hierarchical Data Format Release 4
\item HDF4Image - HDF4 Dataset
\item HDF5 - Hierarchical Data Format Release 5
\item HDF5Image - HDF5 Dataset
\item KEA - KEA Image Format (.kea)
\item MG4Lidar - MrSID Generation 4 / Lidar (.sid)
\item MrSID - Multi-resolution Seamless Image Database (MrSID)
\item netCDF - Network Common Data Format
\item PostgreSQL - PostgreSQL/PostGIS
\item VRT - Virtual Raster
\item GTiff - GeoTIFF
\item NITF - National Imagery Transmission Format
\item RPFTOC - Raster Product Format TOC format
\item ECRGTOC - ECRG TOC format
\item HFA - Erdas Imagine Images (.img)
\item SAR_CEOS - CEOS SAR Image
\item CEOS - CEOS Image
\item JAXAPALSAR - JAXA PALSAR Product Reader (Level 1.1/1.5)
\item GFF - Ground-based SAR Applications Testbed File Format (.gff)
\item ELAS - ELAS
\item AIG - Arc/Info Binary Grid
\item AAIGrid - Arc/Info ASCII Grid
\item GRASSASCIIGrid - GRASS ASCII Grid
\item SDTS - SDTS Raster
\item DTED - DTED Elevation Raster
\item PNG - Portable Network Graphics
\item JPEG - JPEG JFIF
\item MEM - In Memory Raster
\item JDEM - Japanese DEM (.mem)
\item GIF - Graphics Interchange Format (.gif)
\item BIGGIF - Graphics Interchange Format (.gif)
\item ESAT - Envisat Image Format
\item BSB - Maptech BSB Nautical Charts
\item XPM - X11 PixMap Format
\item BMP - MS Windows Device Independent Bitmap
\item DIMAP - SPOT DIMAP
\item AirSAR - AirSAR Polarimetric Image
\item RS2 - RadarSat 2 XML Product
\item SAFE - Sentinel SAFE Product
\item PCIDSK - PCIDSK Database File
\item PCRaster - PCRaster Raster File
\item ILWIS - ILWIS Raster Map
\item SGI - SGI Image File Format 1.0
\item SRTMHGT - SRTMHGT File Format
\item Leveller - Leveller heightfield
\item Terragen - Terragen heightfield
\item ISIS3 - USGS Astrogeology ISIS cube (Version 3)
\item ISIS2 - USGS Astrogeology ISIS cube (Version 2)
\item PDS - NASA Planetary Data System
\item VICAR - MIPL VICAR file
\item TIL - EarthWatch .TIL
\item ERS - ERMapper .ers Labelled
\item JP2OpenJPEG - JPEG-2000 driver based on OpenJPEG library
\item L1B - NOAA Polar Orbiter Level 1b Data Set
\item FIT - FIT Image
\item GRIB - GRIdded Binary (.grb)
\item RMF - Raster Matrix Format
\item WCS - OGC Web Coverage Service
\item WMS - OGC Web Map Service
\item MSGN - EUMETSAT Archive native (.nat)
\item RST - Idrisi Raster A.1
\item INGR - Intergraph Raster
\item GSAG - Golden Software ASCII Grid (.grd)
\item GSBG - Golden Software Binary Grid (.grd)
\item GS7BG - Golden Software 7 Binary Grid (.grd)
\item COSAR - COSAR Annotated Binary Matrix (TerraSAR-X)
\item TSX - TerraSAR-X Product
\item COASP - DRDC COASP SAR Processor Raster
\item R - R Object Data Store
\item MAP - OziExplorer .MAP
\item PNM - Portable Pixmap Format (netpbm)
\item DOQ1 - USGS DOQ (Old Style)
\item DOQ2 - USGS DOQ (New Style)
\item ENVI - ENVI .hdr Labelled
\item EHdr - ESRI .hdr Labelled
\item GenBin - Generic Binary (.hdr Labelled)
\item PAux - PCI .aux Labelled
\item MFF - Vexcel MFF Raster
\item MFF2 - Vexcel MFF2 (HKV) Raster
\item FujiBAS - Fuji BAS Scanner Image
\item GSC - GSC Geogrid
\item FAST - EOSAT FAST Format
\item BT - VTP .bt (Binary Terrain) 1.3 Format
\item LAN - Erdas .LAN/.GIS
\item CPG - Convair PolGASP
\item IDA - Image Data and Analysis
\item NDF - NLAPS Data Format
\item EIR - Erdas Imagine Raw
\item DIPEx - DIPEx
\item LCP - FARSITE v.4 Landscape File (.lcp)
\item GTX - NOAA Vertical Datum .GTX
\item LOSLAS - NADCON .los/.las Datum Grid Shift
\item NTv2 - NTv2 Datum Grid Shift
\item CTable2 - CTable2 Datum Grid Shift
\item ACE2 - ACE2
\item SNODAS - Snow Data Assimilation System
\item KRO - KOLOR Raw
\item ROI_PAC - ROI_PAC raster
\item ISCE - ISCE raster
\item ARG - Azavea Raster Grid format
\item RIK - Swedish Grid RIK (.rik)
\item USGSDEM - USGS Optional ASCII DEM (and CDED)
\item GXF - GeoSoft Grid Exchange Format
\item NWT_GRD - Northwood Numeric Grid Format .grd/.tab
\item NWT_GRC - Northwood Classified Grid Format .grc/.tab
\item ADRG - ARC Digitized Raster Graphics
\item SRP - Standard Raster Product (ASRP/USRP)
\item BLX - Magellan topo (.blx)
\item Rasterlite - Rasterlite
\item PostGISRaster - PostGIS Raster driver
\item SAGA - SAGA GIS Binary Grid (.sdat)
\item KMLSUPEROVERLAY - Kml Super Overlay
\item XYZ - ASCII Gridded XYZ
\item HF2 - HF2/HFZ heightfield raster
\item PDF - Geospatial PDF
\item OZI - OziExplorer Image File
\item CTG - USGS LULC Composite Theme Grid
\item E00GRID - Arc/Info Export E00 GRID
\item ZMap - ZMap Plus Grid
\item NGSGEOID - NOAA NGS Geoid Height Grids
\item MBTiles - MBTiles
\item IRIS - IRIS data (.PPI, .CAPPi etc)
\item PLMOSAIC - Planet Labs Mosaic
\item CALS - CALS (Type 1)
\item WMTS - OGC Web Map Tile Service
\item ESRI Shapefile - ESRI Shapefile
\item MapInfo File - MapInfo File
\item UK .NTF - UK .NTF
\item OGD_SDTS - SDTS
\item S57 - IHO S-57 (ENC)
\item DGN - Microstation DGN
\item OGR_VRT - VRT - Virtual Datasource
\item REC EPIInfo .REC
\item Memory - Memory
\item BNA - Atlas BNA
\item CSV - Comma Separated Value (.csv)
\item NAS - NAS - ALKIS
\item GML - Geography Markup Language
\item GPX - GPX
\item LIBKML - Keyhole Markup Language (LIBKML)
\item KML - Keyhole Markup Language (KML)
\item GeoJSON - GeoJSON
\item Interlis 1 - Interlis 1
\item Interlis 2 - Interlis 2
\item OGR_GMT - GMT ASCII Vectors (.gmt)
\item GPKG - GeoPackage
\item SQLite - SQLite / Spatialite
\item ODBC - ODBC
\item WAsP - WAsP .map format
\item PGeo - ESRI Personal GeoDatabase
\item MSSQLSpatial - Microsoft SQL Server Spatial Database
\item MySQL - MySQL
\item OpenFileGDB - ESRI FileGDB
\item XPlane - X-Plane/Flightgear aeronautical data
\item DXF - AutoCAD DXF
\item Geoconcept - Geoconcept
\item GeoRSS - GeoRSS
\item GPSTrackMaker - GPSTrackMaker
\item VFK - Czech Cadastral Exchange Data Format
\item PGDUMP - PostgreSQL SQL dump
\item OSM - OpenStreetMap XML and PDF
\item GPSBabel - GPSBabel
\item SUA - Tim Newport-Peace's Special Use Airspace Format
\item OpenAir - OpenAir
\item OGR_PDS - Planetary Data Systems TABLE
\item WFS - OGC WFS (Web Feature Service)
\item HTF - Hydrographic Transfer Vector
\item AeronavFAA - Aeronav FAA
\item Geomedia - Geomedia .mdb
\item EDIGEO - French EDIGEO exchange format
\item GFT - Google Fusion Tables
\item GME - Google Maps Engine
\item SVG - Scalable Vector Graphics
\item CouchDB - CouchDB / GeoCouch
\item Cloudant - Cloudant / CouchDB
\item Idrisi - Idrisi Vector (.vct)
\item ARCGEN - Arc/Info Generate
\item SEGUKOOA - SEG-P1 / UKOOA P1/90
\item SEG-Y - SEG-Y
\item ODS - Open Document/ LibreOffice / OpenOffice Spreadsheet
\item XLSX - MS Office Open XML spreadsheet
\item ElasticSearch - Elastic Search
\item Walk - Walk
\item CartoDB - CartoDB
\item SXF - Storage and eXchange Format
\item Selafin - Selafin
\item JML - OpenJUMP JML
\item PLSCENES - Planet Labs Scenes API
\item CSW - OGC CSW (Catalog Search for the Web)
\item IDF - INTREST Data Format
\item TIGER - U.S. Census TIGER/Line
\item AVCBin - Arc/Info Binary Coverage
\item AVCE00 - Arc/Info E00 (ASCII) Coverage
\item HTTP - HTTP Fetching Wrapper
}
}
\references{
GDAL website: \url{http://www.gdal.org/}
}
\seealso{
\code{read.ascii.grid}, \code{rsaga.esri.to.sgrd}, \code{read.sgrd}, \code{read.Rd.grid}
}
\author{
Alexander Brenning (R interface), Olaf Conrad / Andre Ringeler (SAGA module), Frank Warmerdam (GDAL)
}
\keyword{file}
\keyword{interface}
\keyword{spatial}
