% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescaleRR.R
\name{rescaleRR}
\alias{rescaleRR}
\title{Rescaling phylogenetic trees according to RRphylo rates}
\usage{
rescaleRR(tree,RR)
}
\arguments{
\item{tree}{the phylogenetic tree to be rescaled.}

\item{RR}{the result of \code{RRphylo} performed on \code{tree}. When a
multivariate phenotype is used, rescaling is operated on the norm-2 vector
of rates}
}
\value{
Rescaled phylogenetic tree.
}
\description{
The function rescales all branches and leaves of the
  phylogenetic tree according to branch-wise phenotypic evolutionary rates
  fitted by \code{\link{RRphylo}}.
}
\examples{
\dontrun{
library(ape)

rtree(100)->tree
fastBM(tree)->y

RRphylo::RRphylo(tree,y)->RR
rescaleRR(tree,RR)->treeRes
}
}
\references{
Castiglione, S., Serio, C., Piccolo, M., Mondanaro, A.,
  Melchionna, M., Di Febbraro, M., Sansalone, G., Wroe, S., & Raia, P.
  (2020). The influence of domestication, insularity and sociality on the
  tempo and mode of brain size evolution in mammals. \emph{Biological Journal
  of the Linnean Society},in press. doi:10.1093/biolinnean/blaa186
}
\author{
Silvia Castiglione, Pasquale Raia, Carmela Serio
}
