% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conv.map.R
\name{conv.map}
\alias{conv.map}
\title{Mapping morphological convergence on 3D surfaces}
\usage{
conv.map(dataset,pcs,mshape,conv=NULL, exclude=NULL,out.rem=TRUE,
  show.consensus=FALSE, plot=TRUE,col="blue",names = TRUE)
}
\arguments{
\item{dataset}{data frame (or matrix) with the RW (or PC) scores of the group
or species to be compared.}

\item{pcs}{RW (or PC) vectors (eigenvectors of the covariance matrix) of all
the samples.}

\item{mshape}{the Consensus configuration.}

\item{conv}{a named character vector indicating convergent species as
(indicated as "conv" in \code{dataset}) and not convergent species
(indicated as "noconv").}

\item{exclude}{integer: the index number of the RW (or PC) to be excluded
from the comparison.}

\item{out.rem}{logical: if \code{TRUE} triangles with outlying area
difference are removed.}

\item{show.consensus}{logical: if \code{TRUE}, the Consensus configuration is
included in the comparison.}

\item{plot}{logical: if \code{TRUE}, the pairwise comparisons are be plotted.
For more than 5 pairwise comparisons, the plot is not shown.}

\item{col}{character: the colour for the plot.}

\item{names}{logical: if \code{TRUE}, the names of the groups or species are
displayed in the 3d plot.}
}
\value{
The function returns a list including:
  \itemize{\item\strong{$angle.compare} data frame including the real angles
  between the given shape vectors, the angles conv computed between vectors
  of the selected RWs (or PCs), the angles between vectors of the
  non-selected RWs (or PCs), the difference conv, and its p values.
  \item\strong{$selected.pcs} RWs (or PCs) axes selected for convergence.
  \item\strong{$average.dist} symmetric matrix of pairwise distances between
  3D surfaces. \item\strong{$suface1} list of coloured surfaces, if two
  meshes are given, it represents convergence between mesh A and B charted on
  mesh A. \item\strong{$suface2} list of coloured surfaces, if two meshes are
  given, it represents convergence between mesh A and B charted on mesh B.
  \item \strong{$scale} the value used to set the colour gradient, computed
  as the maximum of all differences between each surface and the mean shape.}
}
\description{
Given vectors of RW (or PC) scores, the function selects the
  RW(PC) axes which best account for convergence and maps convergent areas on
  the corresponding 3D surfaces.
}
\details{
\code{conv.map} automatically builds a 3D mesh on the mean shape
  calculated from the Relative Warp Analysis (RWA) or Principal Component
  Analysis (PCA) (\cite{Schlager 2017}) by applying the function
  \code{\link[Rvcg]{vcgBallPivoting}} (\pkg{Rvcg}). \code{conv.map} further
  gives the opportunity to exclude some RW (or PC) axes from the analysis
  because, for example, in most cases the first axes are mainly related to
  high-order morphological differences driven by phylogeny and size
  variations. \code{conv.map} finds and plots the strength of convergence on
  3D surfaces. An output of \code{conv.map} (if the dataset contains a number
  equal or lower then 5 items) is an interactive plot mapping the convergence
  on the 3D models. In the upper triangle of the 3D multiple layouts the rows
  representing the reference models and the columns the target models. On the
  contrary, on the lower triangle the rows correspond to the target models
  and the columns the reference models. In the calculation of the differences
  of areas we supply the possibility to find and remove outliers from the
  vectors of areas calculated on the reference and target surfaces. We
  suggest considering this possibility if the mesh may contain degenerate
  facets.
}
\examples{
  \dontrun{
  data(DataSimians)
  DataSimians$pca->pca

  ## Case 1. Convergent species only
     dato<-pca$PCscores[c(1,4),]

     CM<-conv.map(dataset = dato,
                 pcs = pca$PCs,
                 mshape = pca$mshape,
                 show.consensus = TRUE)

  ## Case 2. Convergent and non-convergent species
     dato<-pca$PCscores[c(1,4,7),]
     conv<-c("conv","conv","noconv")
     names(conv)<-rownames(dato)

     CM<-conv.map(dataset = dato,
                  pcs = pca$PCs,
                  mshape = pca$mshape,
                  conv = conv,
                  show.consensus = TRUE,
                  col = "orange")
  }
}
\references{
Schlager, S. (2017). \emph{Morpho and Rvcg–Shape Analysis in R:
  R-Packages for geometric morphometrics, shape analysis and surface
  manipulations.} In: Statistical shape and deformation analysis. Academic
  Press.
  Melchionna, M., Profico, A., Castiglione, S., Serio, C., Mondanaro,
  A., Modafferi, M., Tamagnini, D., Maiorano, L. , Raia, P., Witmer, L.M.,
  Wroe, S., & Sansalone, G. (2021). A method for mapping morphological
  convergence on three‐dimensional digital models: the case of the mammalian
  sabre-tooth. Palaeontology, 64, 573–584. doi:10.1111/pala.12542
}
\seealso{
\href{../doc/search.conv.html}{\code{search.conv} vignette} ;
  \code{\link[Morpho]{relWarps}} ; \code{\link[Morpho]{procSym}}
}
\author{
Marina Melchionna, Antonio Profico, Silvia Castiglione, Carmela
  Serio, Gabriele Sansalone, Pasquale Raia
}
