#' @title Example dataset
#' @description Geometric morphometrics shape data regarding Apes' facial skeleton and Apes phylogentic trees (\cite{Profico et al. 2017}).
#' @name DataApes
#' @format A list containing:
#' \describe{
#' \item{\strong{$PCstage}}{A data frame containing 38 shape variables for Apes' facial skull at different ontogenetic stages}.
#' \item{\strong{$PCadult}}{A data frame containing 3 shape variables for Apes' facial skull}.
#' \item{\strong{$Tstage}}{Phylogenetic tree of Apes including the different ontogenetic stages of each species as polytomies}.
#' \item{\strong{$Tadult}}{Phylogenetic tree of Apes}.
#' \item{\strong{$CentroidSize}}{numeric vector of Centroid Size values of \sQuote{PCstage}}.
#' }
#' @docType data
#' @author Pasquale Raia, Silvia Castiglione, Carmela Serio, Alessandro Mondanaro, Marina Melchionna, Mirko Di Febbraro, Antonio Profico, Francesco Carotenuto
#' @keywords RRphylo
#' @usage data(DataApes)
#' @references Profico, A., Piras, P., Buzi, C., Di Vincenzo, F., Lattarini, F., Melchionna, M., Veneziano, A., Raia, P. & Manzi, G. (2017). The evolution of cranial base and face in Cercopithecoidea and Hominoidea: Modularity and morphological integration. American journal of primatology, 79(12).
NULL
