% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ForcedResponse.R
\name{ForcedResponse}
\alias{ForcedResponse}
\title{Forced-Response model}
\usage{
ForcedResponse(z,p1,p2,pi,type=c("total","mean"),cl,N=NULL,pij=NULL)
}
\arguments{
\item{z}{vector of the observed variable; its length is equal to \eqn{n} (the sample size)}

\item{p1}{proportion of cards marked "Yes"}

\item{p2}{proportion of cards marked "No"}

\item{pi}{vector of the first-order inclusion probabilities}

\item{type}{the estimator type: total or mean}

\item{cl}{confidence level}

\item{N}{size of the population. By default it is NULL}

\item{pij}{matrix of the second-order inclusion probabilities. By default it is NULL}
}
\value{
Point and confidence estimates of the sensitive characteristics using the Forced-Response model. The transformed variable is also reported, if required.
}
\description{
Computes the randomized response estimation, its variance estimation and its confidence interval through the Forced-Response model.
The function can also return the transformed variable.
The Forced-Response model was proposed by Boruch in 1972.
}
\details{
In the Forced-Response scheme, the sampled person \eqn{i} is offered a box with cards: some are marked "Yes" with a proportion \eqn{p_1}, some are marked "No" with a
proportion \eqn{p_2} and the rest are marked "Genuine", in the remaining proportion \eqn{p_3=1-p_1-p_2}, where \eqn{0<p_1,p_2<1,p_1\neq p_2,p_1+p_2<1}. The person is
requested to randomly draw one of them, to observe the mark on the card, and to respond
\deqn{z_i=\left \{\begin{array}{lccc}
1 & \textrm{if the card is type "Yes"}\\
0 & \textrm{if the card is type "No"}\\
y_i & \textrm{if the card is type "Genuine"}
\end{array}
\right .}
The transformed variable is \eqn{r_i=\frac{z_i-p_1}{1-p_1-p_2}} and the estimated variance is \eqn{\widehat{V}_R(r_i)=r_i(r_i-1)}.
}
\examples{
data(ForcedResponseData)
dat=with(ForcedResponseData,data.frame(z,Pi))
p1=0.2
p2=0.2
cl=0.95
ForcedResponse(dat$z,p1,p2,dat$Pi,"total",cl)
}
\references{
Boruch, R.F. (1972).
\emph{Relations among statistical methods for assuring confidentiality of social research data.}
 Social Science Research, 1, 403-414.
}
\seealso{
\code{\link{ForcedResponseData}}

\code{\link{ResamplingVariance}}
}
\keyword{Boruch}
\keyword{Confidence_interval}
\keyword{Estimation}
\keyword{ForcedResponse}
\keyword{Qualitative}
\keyword{Randomized_response}
\keyword{Transformed_variable}
\keyword{Variance}

