% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbplyr-src.R
\name{tbl.src_presto}
\alias{tbl.src_presto}
\alias{tbl.PrestoConnection}
\alias{copy_to.src_presto}
\alias{copy_to.PrestoConnection}
\title{dplyr integration to connect to a table in a database.}
\usage{
\method{tbl}{src_presto}(src, from, ..., vars = NULL)

\method{tbl}{PrestoConnection}(src, from, ...)

\method{copy_to}{src_presto}(
  dest,
  df,
  name = deparse(substitute(df)),
  overwrite = FALSE,
  ...,
  with = NULL
)

\method{copy_to}{PrestoConnection}(
  dest,
  df,
  name = deparse(substitute(df)),
  overwrite = FALSE,
  ...,
  with = NULL
)
}
\arguments{
\item{src}{A \code{PrestoConnection} object produced by \code{DBI::dbConnect()}.}

\item{from}{Either a string (giving a table name) or a literal
\code{\link[dbplyr:sql]{dbplyr::sql()}} string.}

\item{...}{Passed on to \code{\link[dbplyr:tbl_sql]{dbplyr::tbl_sql()}}}

\item{vars}{Provide column names as a character vector
to avoid retrieving them from the database.}

\item{dest}{remote data source}

\item{df}{local data frame}

\item{name}{name for new remote table.}

\item{overwrite}{If \code{TRUE}, will overwrite an existing table with
name \code{name}. If \code{FALSE}, will throw an error if \code{name} already
exists.}

\item{with}{An optional WITH clause for the CREATE TABLE statement.}
}
\description{
Use \code{src_presto} to connect to an existing database,
and \code{tbl} to connect to tables within that database.
If you're unsure of the arguments to pass, please ask your database
administrator for the values of these variables.

Automatically create a Presto remote database source to wrap aroudn the
\code{PrestoConnection} object via which DBI APIs can be called.
}
\examples{
\dontrun{
# First create a database connection with src_presto, then reference a tbl
# within that database
my_db <- src_presto(
  catalog = "memory",
  schema = "default",
  user = Sys.getenv("USER"),
  host = "http://localhost",
  port = 8080,
  session.timezone = "Asia/Kathmandu"
)
my_tbl <- tbl(my_db, "my_table")
}
\dontrun{
# First create a database connection, then reference a tbl within that
# database
my_con <- DBI::dbConnect(
  catalog = "memory",
  schema = "default",
  user = Sys.getenv("USER"),
  host = "http://localhost",
  port = 8080,
  session.timezone = "Asia/Kathmandu"
)
my_tbl <- tbl(my_con, "my_table")
}
}
\keyword{internal}
