% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.presto.R, R/tbl.src.presto.R
\name{src_presto}
\alias{src_presto}
\alias{tbl.src_presto}
\title{dplyr integration to connect to a Presto database.}
\usage{
src_presto(
  catalog = NULL,
  schema = NULL,
  user = NULL,
  host = NULL,
  port = NULL,
  source = NULL,
  session.timezone = NULL,
  parameters = NULL,
  ...
)

tbl.src_presto(src, from, ...)
}
\arguments{
\item{catalog}{Catalog to use in the connection}

\item{schema}{Schema to use in the connection}

\item{user}{User name to use in the connection}

\item{host}{Host name to connect to the database}

\item{port}{Port number to use with the host name}

\item{source}{Source to specify for the connection}

\item{session.timezone}{Time zone for the connection}

\item{parameters}{Additional parameters to pass to the connection}

\item{...}{For \code{src_presto} other arguments passed on to the underlying
database connector \code{dbConnect}. For \code{tbl.src_presto}, it is
included for compatibility with the generic, but otherwise ignored.}

\item{src}{A presto src created with \code{src_presto}.}

\item{from}{Either a string giving the name of table in database, or
\code{\link[dplyr]{sql}} described a derived table or compound join.}
}
\description{
Allows you to connect to an existing database through a presto connection.

Use \code{src_presto} to connect to an existing database,
and \code{tbl} to connect to tables within that database.
If you're unsure of the arguments to pass, please ask your database
administrator for the values of these variables.
}
\examples{
\dontrun{
# To connect to a database
my_db <- src_presto(catalog = "hive", schema = "web", user = "onur",
  host = "localhost", port = 8888, session.timezone='Asia/Kathmandu')
}
\dontrun{
First create a database connection with src_presto, then reference a tbl
within that database
my_tbl <- tbl(my_db, "my_table")
}
}
