% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectsymm_RPS.R
\name{objectsymm_RPS}
\alias{objectsymm_RPS}
\title{This function obtains the individual resistant-symmetric shape for 2D
object-symmetry data. The input is an array A of size
n (landmarks) x p (dimensions) x k (objects)
Landmarks must be in this order: saggital (or unpaired) landmarks first,
then left paired landmarks and finally right paired landmarks.
Configurations are ordered in this way: L side Object 1 and R side Object 1,
L side Object 2 and R side Object 2, etc}
\usage{
objectsymm_RPS(A,ctr="gmedian",prs.file,proj.met="msum",legend.loc="topleft")
}
\arguments{
\item{A}{Input data: an array or matrix of size n (landmarks) x 2 (in 2D) x k (objects)}

\item{ctr}{Centering options: "gmedian" (the spatial or gemetric median, default choice), "median" (the componentwise median), "mean" (the average)}

\item{prs.file}{This is a .txt file indicating the L+R paired landmarks as rows: e.g. 7 15; 8 16; etc.}

\item{proj.met}{The choice to compute the saggital axis: sum or median of projections}

\item{legend.loc}{The location of the legend for the plot.result function}
}
\value{
w
}
\description{
This function obtains the individual resistant-symmetric shape for 2D
object-symmetry data. The input is an array A of size
n (landmarks) x p (dimensions) x k (objects)
Landmarks must be in this order: saggital (or unpaired) landmarks first,
then left paired landmarks and finally right paired landmarks.
Configurations are ordered in this way: L side Object 1 and R side Object 1,
L side Object 2 and R side Object 2, etc
}
\author{
Federico Lotto, Sebastian Torcida
}
