% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IF_robLoc.R
\name{IF.robMean}
\alias{IF.robMean}
\title{Influence Function - Robust M-Estimator of Mean}
\usage{
IF.robMean(
  returns = NULL,
  family = c("mopt", "opt", "bisquare")[1],
  eff = 0.95,
  evalShape = FALSE,
  retVals = NULL,
  nuisPars = NULL,
  k = 4,
  IFplot = FALSE,
  IFprint = TRUE,
  prewhiten = FALSE,
  ar.prewhiten.order = 1,
  ...
)
}
\arguments{
\item{returns}{Returns data of the asset or portfolio. This can be a numeric or an xts object.}

\item{family}{Family for robust m-estimator of Mean. Must be one of "mopt" (default), "opt" or "bisquare".}

\item{eff}{Tuning parameter for the normal distribution efficiency. Default is 0.99.}

\item{evalShape}{Evaluation of the shape of the IF risk or performance measure if TRUE. Otherwise, a TS of the IF of the provided returns is computed.}

\item{retVals}{Values used to evaluate the shape of the IF.}

\item{nuisPars}{Nuisance parameters used for the evaluation of the shape of the IF (if no returns are provided).}

\item{k}{Range parameter for the shape of the IF (the SD gets multiplied k times).}

\item{IFplot}{If TRUE, the plot of the IF shape or IF TS of the returns is produced.}

\item{IFprint}{If TRUE, the data for the IF shape or the IF TS of the returns is returned.}

\item{prewhiten}{Boolean variable to indicate if the IF TS is pre-whitened (TRUE) or not (FALSE).}

\item{ar.prewhiten.order}{Order of AR parameter for the pre-whitening. Default is AR(1).}

\item{...}{Addtional parameters.}
}
\value{
Influence function for M-estimator of Mean
}
\description{
\code{IF.robMean} returns the data and plots the shape of either the IF or the IF TS for the M-estimator of Mean.
}
\details{
For further details on the usage of the \code{nuisPars} argument, please refer to Section 3.1 for the \code{RPEIF} vignette.
}
\examples{
data(edhec)
colnames(edhec) = c("CA", "CTAG", "DIS", "EM","EMN", "ED", "FIA",
                    "GM", "LS", "MA", "RV", "SS", "FoF") 
                    
# Plot of IF shape
outIF <- IF.robMean(returns = edhec[,"CA"], evalShape = TRUE, 
                    retVals = NULL, 
                    IFplot = TRUE, IFprint = TRUE)

# Plot of IF a specified TS 
outIF <- IF.robMean(returns = edhec[,"CA"], evalShape = TRUE, 
                    retVals = seq(-0.1, 0.1, by = 0.001), 
                    IFplot = TRUE, IFprint = TRUE)

# Computing the IF of the returns (with prewhitening) with a plot of IF TS
outIF <- IF.robMean(returns = edhec[,"CA"], evalShape = FALSE, 
                    retVals = NULL, 
                    IFplot = TRUE, IFprint = TRUE,
                    prewhiten = FALSE)

}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
