% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maximum.R
\name{maximum (Set/Get)}
\alias{maximum (Set/Get)}
\alias{maximum}
\alias{maximum<-}
\title{Maximum - Accessor and Mutator Functions}
\usage{
maximum(x)

maximum(x) <- value
}
\arguments{
\item{x}{an object used to select the method.}

\item{value}{an R object.}
}
\value{
a logical giving the direction.
}
\description{
The \link{maximum} of a given optimization problem (\link{OP})
    can be accessed or mutated via the method \code{'maximum'}.
    If \code{'maximum'} is set to \code{TRUE} the \link{OP} is maximized,
    if \code{'maximum'} is set to \code{FALSE} the \link{OP} is minimized.
}
\examples{
## maximize: x + y
## subject to: x + y <= 2
## x, y >= 0
x <- OP(objective = c(1, 1), 
        constraints = L_constraint(L = c(1, 1), dir = "<=", rhs = 2),
        maximum = FALSE)
maximum(x) <- TRUE
maximum(x)
}
