% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bounds.R
\name{bounds (Set/Get)}
\alias{bounds (Set/Get)}
\alias{bounds}
\alias{bounds.OP}
\alias{bounds<-}
\title{Bounds - Accessor and Mutator Functions}
\usage{
bounds(x)

\method{bounds}{OP}(x)

bounds(x) <- value
}
\arguments{
\item{x}{an object of type \code{'OP'} used to select the method.}

\item{value}{an object derived from \code{'bound'} 
(\code{'\link{V_bound}'}) or \code{NULL}.}
}
\value{
the extracted bounds object on get and the altered \code{'\link{OP}'}
  object on set.
}
\description{
The \link{bounds} of a given optimization problem (\link{OP}) 
  can be accessed or mutated via the method \code{'bounds'}.
}
\examples{
\dontrun{
lp_obj <- L_objective(c(1, 2))
lp_con <- L_constraint(c(1, 1), dir="==", rhs=2)
lp_bound <- V_bound(ui=1:2, ub=c(3, 3))
lp <- OP(objective=lp_obj, constraints=lp_con, bounds=lp_bound, maximum=FALSE)
bounds(lp)
x <- ROI_solve(lp)
x$objval
x$solution
bounds(lp) <- V_bound(ui=1:2, ub=c(1, 1))
y <- ROI_solve(lp)
y$objval
y$solution
}
}
