% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aucCI.R
\name{ciAUC.rocit}
\alias{ciAUC.rocit}
\title{Confidence Interval of AUC}
\usage{
\method{ciAUC}{rocit}(object, level = 0.95, delong = FALSE,
  logit = FALSE, nboot = NULL, ... = NULL)
}
\arguments{
\item{object}{An object of class \code{"rocit"}, returned by
\code{\link{rocit}}.}

\item{level}{Level of confidence, must be within the range (0 1).
Default is 0.95.}

\item{delong}{Logical; indicates whether DeLong formula should
be used to estimate the variance of AUC. Default is \code{FALSE}.}

\item{logit}{Logical; indicates whether confidence interval of
logit transformed AUC should be evaluated first. Default is \code{FALSE}}

\item{nboot}{Number of bootstrap samples, if bootstrap method is desired.
Default is NULL. If a numeric value is specified, overrides
\code{logit} and \code{delong} arguments.}

\item{...}{\code{NULL}. Used for S3 generic/method consistency.}
}
\value{
An object of class \code{"rocitaucci"}.
}
\description{
\code{ciAUC} constructs confidence interval
of area under curve (AUC) of receiver operating characteristic (ROC)
curve. This is an S3 method defined for object of class \code{"rocit"}.
}
\examples{
data("Diabetes")
logistic.model <- glm(as.factor(dtest)~chol+age+bmi,
                      data = Diabetes,family = "binomial")
score <- logistic.model$fitted.values
class <- logistic.model$y
# Make the rocit objects
rocit_bin <- rocit(score = score, class = class, method = "bin")
# Confidence interval of AUC
ciAUC(rocit_bin, level = 0.9)
ciAUC(rocit_bin, delong = TRUE, logit = TRUE)

}
\seealso{
\code{\link{rocit}}, \code{\link{ciROC.rocit}}
}
