% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/addConstraint.R
\name{addConstraint}
\alias{addConstraint}
\title{Uniqueness Constraints}
\usage{
addConstraint(graph, label, key)
}
\arguments{
\item{graph}{A graph object.}

\item{label}{A character string.}

\item{key}{A character string.}
}
\description{
Add a uniqueness constraint to a label and property key.
}
\details{
A uniqueness constraint cannot be added to a (label, key) pair that already has an index applied.
Attempting to add a uniqueness constraint where an index already exists results in an error.
Use \code{\link{getIndex}} to view any pre-existing indexes.
If you wish to add a uniqueness constraint, use \code{\link{dropIndex}} to drop the index.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

addConstraint(graph, "Person", "name")

createNode(graph, "Person", name = "Alice")
createNode(graph, "Person", name = "Bob")
try(createNode(graph, "Person", name = "Alice"))
}
}
\seealso{
\code{\link{getConstraint}}, \code{\link{dropConstraint}}
}

