% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenUniGpois.R
\name{GenUniGpois}
\alias{GenUniGpois}
\title{Generates Univariate Generalized Poisson Variates}
\usage{
GenUniGpois(theta, lambda, n, details = TRUE, method)
}
\arguments{
\item{theta}{the rate parameter in the generalized Poisson distribution. It has to be a positive number.}

\item{lambda}{the dispersion parameter in the generalized Poisson distribution.
It has to be < 1. For lambda < 0, lambda must be greater than or equal to -theta/4.}

\item{n}{number of data points that is to be generated.}

\item{details}{index to indicate whether or not to print out the estimates of parameters.
The default is set as TRUE.}

\item{method}{index to specify one of the five methods: "Inversion", "Branching", "Normal-Approximation", "Build-Up" and "Chop-Down".}
}
\value{
a list that includes generated data, specified and empirical vlaues of theta and lambda.
}
\description{
\code{GenUniGpois} generates univariate random variables from the generalized Poisson
distribution using one of the five methods including: Inversion, Branching, Normal-Approximation, Build-Up, Chop-Down.
}
\details{
All five methods come from Demirtas (2017).
 When lambda equals 0, it is the ordinary Poisson distribution, so there is no need to specify the method.
 "Branching" only works when lambda is positive.
 When theta is less than 10, a "Normal-Approximation" may not be reliable.
}
\examples{
 GenUniGpois(2, 0.9, 100, method = "Branching")
 GenUniGpois(5, -0.4, 100, method = "Inversion")
 GenUniGpois(12, 0.5, 100, method = "Normal-Approximation")
 data <- GenUniGpois(10, 0.4, 10, method = "Chop-Down", details = FALSE)
 data <- GenUniGpois(3, 0.9, 10000, method = "Build-Up", details = FALSE)
}
\references{
Demirtas, H. (2017). On accurate and precise generation of generalized
 Poisson variates. \emph{Communications in Statistics - Simulation and Computation},
  \bold{46(1)}, 489-499.
}
