% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cos.R
\name{PdfMultiPlot}
\alias{PdfMultiPlot}
\title{Plot the Probability Density Functions}
\usage{
PdfMultiPlot(data, x, y, Variable)
}
\arguments{
\item{data}{a tibble contains x, y and Variable and the last one is the group variable}

\item{x}{x}

\item{y}{y}

\item{Variable}{the group label}
}
\value{
A ggplot figure of the probability density functions
}
\description{
Plot the p.d.f functions for the univariate distribution with data processed by StackRet.
}
\examples{
N <- 2**(1:6)
x <- seq(-5, 5, by = 10 / (32 - 1))
a <- -10.0
b <- 10.0
f_x1 <- CosPdfMulti(x, StNormChf, N, a, b)
colnames(f_x1) <- paste("N = 2 ^ ", c(1:6), sep = "")
mt1 <- StackRet(f_x1, x)
colnames(mt1) <- c("x", "y", "Variable")
PdfMultiPlot(mt1, x, y, Variable)
}
