/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import weka.core.Utils;
import weka.core.Version;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;

public class ResultMatrixGnuPlot
extends ResultMatrix {
    public ResultMatrixGnuPlot() {
        this(1, 1);
    }

    public ResultMatrixGnuPlot(int n, int n2) {
        super(n, n2);
    }

    public ResultMatrixGnuPlot(ResultMatrix resultMatrix) {
        super(resultMatrix);
    }

    public String getDisplayName() {
        return "GNUPlot";
    }

    public void clear() {
        super.clear();
        this.setRowNameWidth(50);
        this.setColNameWidth(50);
        this.setEnumerateRowNames(false);
        this.setEnumerateColNames(false);
        this.LEFT_PARENTHESES = "";
        this.RIGHT_PARENTHESES = "";
    }

    public String toStringHeader() {
        return new ResultMatrixPlainText(this).toStringHeader();
    }

    public String toStringMatrix() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        String[][] stringArray = this.toArray();
        String string = "# generated by WEKA " + Version.VERSION + "\n";
        stringBuffer.append("\n");
        stringBuffer.append("##################\n");
        stringBuffer.append("# file: plot.dat #\n");
        stringBuffer.append("##################\n");
        stringBuffer.append(string);
        stringBuffer.append("# contains the data for the plot\n");
        stringBuffer.append("\n");
        stringBuffer.append("# key for the x-axis\n");
        for (n2 = 1; n2 < stringArray.length - 1; ++n2) {
            stringBuffer.append("# " + n2 + " - " + stringArray[n2][0] + "\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("# data for the plot\n");
        for (n2 = 1; n2 < stringArray.length - 1; ++n2) {
            stringBuffer.append(Integer.toString(n2));
            for (n = 1; n < stringArray[n2].length; ++n) {
                if (this.isSignificance(n)) continue;
                stringBuffer.append(" ");
                stringBuffer.append(Utils.quote(stringArray[n2][n]));
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("#######\n");
        stringBuffer.append("# end #\n");
        stringBuffer.append("#######\n");
        stringBuffer.append("\n");
        stringBuffer.append("##################\n");
        stringBuffer.append("# file: plot.scr #\n");
        stringBuffer.append("##################\n");
        stringBuffer.append(string);
        stringBuffer.append("# script to plot the data\n");
        stringBuffer.append("\n");
        stringBuffer.append("# display it in a window:\n");
        stringBuffer.append("set terminal x11\n");
        stringBuffer.append("set output\n");
        stringBuffer.append("\n");
        stringBuffer.append("# to display all data rows:\n");
        stringBuffer.append("set xrange [0:" + (stringArray.length - 2 + 1) + "]\n");
        stringBuffer.append("\n");
        stringBuffer.append("# axis labels, e.g.:\n");
        stringBuffer.append("#set xlabel \"Datasets\"\n");
        stringBuffer.append("#set ylabel \"Accuracy in %\"\n");
        stringBuffer.append("\n");
        stringBuffer.append("# the plot commands\n");
        n = 1;
        n2 = 0;
        while (n2 < stringArray[0].length - 1) {
            if (this.isSignificance(++n2)) continue;
            String string2 = n2 == 1 ? "plot" : "replot";
            string2 = string2 + " \"plot.dat\"";
            String string3 = "title \"" + stringArray[0][n2] + "\"";
            string2 = string2 + " using 1:" + ++n;
            if (this.getShowStdDev()) {
                ++n2;
                string2 = string2 + ":" + ++n;
            }
            string2 = string2 + " with";
            string2 = this.getShowStdDev() ? string2 + " yerrorbars" : string2 + " lines";
            string2 = string2 + " " + string3;
            stringBuffer.append(string2 + "\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("# generate ps:\n");
        stringBuffer.append("#set terminal postscript\n");
        stringBuffer.append("#set output \"plot.ps\"\n");
        stringBuffer.append("#replot\n");
        stringBuffer.append("\n");
        stringBuffer.append("# generate png:\n");
        stringBuffer.append("#set terminal png size 800,600\n");
        stringBuffer.append("#set output \"plot.png\"\n");
        stringBuffer.append("#replot\n");
        stringBuffer.append("\n");
        stringBuffer.append("# wait for user to hit <Return>\n");
        stringBuffer.append("pause -1\n");
        stringBuffer.append("#######\n");
        stringBuffer.append("# end #\n");
        stringBuffer.append("#######\n");
        return stringBuffer.toString();
    }

    public String toStringKey() {
        return new ResultMatrixPlainText(this).toStringKey();
    }

    public String toStringSummary() {
        return new ResultMatrixPlainText(this).toStringSummary();
    }

    public String toStringRanking() {
        return new ResultMatrixPlainText(this).toStringRanking();
    }

    public static void main(String[] stringArray) {
        ResultMatrixGnuPlot resultMatrixGnuPlot = new ResultMatrixGnuPlot(3, 3);
        resultMatrixGnuPlot.addHeader("header1", "value1");
        resultMatrixGnuPlot.addHeader("header2", "value2");
        resultMatrixGnuPlot.addHeader("header2", "value3");
        for (int i = 0; i < resultMatrixGnuPlot.getRowCount(); ++i) {
            for (int j = 0; j < resultMatrixGnuPlot.getColCount(); ++j) {
                resultMatrixGnuPlot.setMean(j, i, (i + 1) * j);
                resultMatrixGnuPlot.setStdDev(j, i, (double)(i + 1) * (double)j / 100.0);
                if (i != j) continue;
                if (i % 2 == 1) {
                    resultMatrixGnuPlot.setSignificance(j, i, 1);
                    continue;
                }
                resultMatrixGnuPlot.setSignificance(j, i, 2);
            }
        }
        System.out.println("\n\n--> " + ((ResultMatrix)resultMatrixGnuPlot).getDisplayName());
        System.out.println("\n1. complete\n");
        System.out.println(((ResultMatrix)resultMatrixGnuPlot).toStringHeader() + "\n");
        System.out.println(((ResultMatrix)resultMatrixGnuPlot).toStringMatrix() + "\n");
        System.out.println(((ResultMatrix)resultMatrixGnuPlot).toStringKey());
        System.out.println("\n2. complete with std deviations\n");
        resultMatrixGnuPlot.setShowStdDev(true);
        System.out.println(((ResultMatrix)resultMatrixGnuPlot).toStringMatrix());
        System.out.println("\n3. cols numbered\n");
        resultMatrixGnuPlot.setPrintColNames(false);
        System.out.println(((ResultMatrix)resultMatrixGnuPlot).toStringMatrix());
        System.out.println("\n4. second col missing\n");
        resultMatrixGnuPlot.setColHidden(1, true);
        System.out.println(((ResultMatrix)resultMatrixGnuPlot).toStringMatrix());
        System.out.println("\n5. last row missing, rows numbered too\n");
        resultMatrixGnuPlot.setRowHidden(2, true);
        resultMatrixGnuPlot.setPrintRowNames(false);
        System.out.println(((ResultMatrix)resultMatrixGnuPlot).toStringMatrix());
        System.out.println("\n6. mean prec to 3\n");
        resultMatrixGnuPlot.setMeanPrec(3);
        resultMatrixGnuPlot.setPrintRowNames(false);
        System.out.println(((ResultMatrix)resultMatrixGnuPlot).toStringMatrix());
    }
}

