/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.Locator;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocatorClassLoader
implements Locator {
    static Log log = LogFactory.getLog((Class)LocatorClassLoader.class);
    ClassLoader classLoader = null;

    LocatorClassLoader(ClassLoader _classLoader) {
        this.classLoader = _classLoader;
    }

    public InputStream open(String filenameOrURI) {
        if (this.classLoader == null) {
            return null;
        }
        String fn = FileUtils.toFilename(filenameOrURI);
        if (fn == null) {
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace((Object)("Not found: " + filenameOrURI));
            }
            return null;
        }
        InputStream in = this.classLoader.getResourceAsStream(fn);
        if (in == null) {
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace((Object)("Failed to open: " + filenameOrURI));
            }
            return in;
        }
        if (FileManager.logAllLookups && log.isTraceEnabled()) {
            log.trace((Object)("Found: " + filenameOrURI));
        }
        return in;
    }

    public String getName() {
        return "ClassLoaderLocator";
    }
}

