/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.IllegalParameterException;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.FBLPRuleInfGraph;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.List;

public class FBLPRuleReasoner
implements Reasoner {
    protected ReasonerFactory factory;
    protected List rules;
    protected Graph schemaGraph;
    protected boolean recordDerivations = false;
    protected boolean traceOn = false;
    protected static final boolean cachePreload = true;
    protected InfGraph preload;
    protected Capabilities capabilities;

    public FBLPRuleReasoner(List rules) {
        this.rules = rules;
    }

    public FBLPRuleReasoner(ReasonerFactory factory) {
        this(null, factory);
    }

    public FBLPRuleReasoner(List rules, ReasonerFactory factory) {
        this(rules);
        this.factory = factory;
    }

    protected FBLPRuleReasoner(List rules, Graph schemaGraph, ReasonerFactory factory) {
        this(rules, factory);
        this.schemaGraph = schemaGraph;
    }

    public Model getReasonerCapabilities() {
        if (this.factory != null) {
            return this.factory.getCapabilities();
        }
        return null;
    }

    public void addDescription(Model configSpec, Resource base) {
    }

    public boolean supportsProperty(Property property) {
        if (this.factory == null) {
            return false;
        }
        Model caps = this.factory.getCapabilities();
        Resource root = caps.getResource(this.factory.getURI());
        return caps.contains(root, ReasonerVocabulary.supportsP, property);
    }

    public Reasoner bindSchema(Graph tbox) throws ReasonerException {
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can only bind one schema at a time to an OWLRuleReasoner");
        }
        FBLPRuleInfGraph graph = new FBLPRuleInfGraph(this, this.rules, this.getPreload(), tbox);
        graph.prepare();
        FBLPRuleReasoner fbr = new FBLPRuleReasoner(this.rules, graph, this.factory);
        fbr.setDerivationLogging(this.recordDerivations);
        fbr.setTraceOn(this.traceOn);
        return fbr;
    }

    public Reasoner bindSchema(Model tbox) throws ReasonerException {
        return this.bindSchema(tbox.getGraph());
    }

    public InfGraph bind(Graph data) throws ReasonerException {
        InfGraph schemaArg = this.schemaGraph == null ? this.getPreload() : (FBLPRuleInfGraph)this.schemaGraph;
        FBLPRuleInfGraph graph = new FBLPRuleInfGraph(this, this.rules, schemaArg);
        graph.setDerivationLogging(this.recordDerivations);
        graph.setTraceOn(this.traceOn);
        graph.rebind(data);
        return graph;
    }

    public void setRules(List rules) {
        this.rules = rules;
        this.preload = null;
    }

    public List getRules() {
        return this.rules;
    }

    public synchronized void tablePredicate(Node predicate) {
        Rule tablePredicateRule = new Rule("", new ClauseEntry[]{new Functor("table", new Node[]{predicate})}, new ClauseEntry[0]);
        this.rules.add(tablePredicateRule);
    }

    protected synchronized InfGraph getPreload() {
        if (this.preload == null) {
            this.preload = new FBLPRuleInfGraph(this, this.rules, null);
            this.preload.prepare();
        }
        return this.preload;
    }

    public void setDerivationLogging(boolean logOn) {
        this.recordDerivations = logOn;
    }

    public void setTraceOn(boolean state) {
        this.traceOn = state;
    }

    public void setParameter(Property parameter, Object value) {
        if (parameter.equals(ReasonerVocabulary.PROPderivationLogging)) {
            this.recordDerivations = Util.convertBooleanPredicateArg(parameter, value);
        } else if (parameter.equals(ReasonerVocabulary.PROPtraceOn)) {
            this.traceOn = Util.convertBooleanPredicateArg(parameter, value);
        } else {
            throw new IllegalParameterException("Don't recognize configuration parameter " + parameter + " for rule-based reasoner");
        }
    }

    public Capabilities getGraphCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new BaseInfGraph.InfCapabilities();
        }
        return this.capabilities;
    }
}

