% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{datasetBinned123}
\alias{datasetBinned123}
\title{Binned dataset suitable for checking \code{\link{FitCorCbm}}; seed = 123}
\format{A list with 8 elements:
\itemize{
\item{\code{NL}}{ Ratings array [1, 1:2, 1:10000, 1], of non-lesion localizations, NLs}
\item{\code{LL}}{ Ratings array [1, 1:2, 1:5000, 1], of lesion localizations, LLs}
\item{\code{lesionNum}}{ array [1:5000], number of lesions per diseased case, all set to one}
\item{\code{lesionID}}{ array [1:5000, 1], lesions labels on diseased cases, all set to one}
\item{\code{lesionWeight}}{ array [1:5000, 1], weights, all set to one}
\item{\code{dataType}}{ "ROC", the data type}
\item{\code{modalityID}}{ "1", treatment label}
\item{\code{readerID}}{ [1:2] "1" "2",  reader labels}
}}
\usage{
datasetBinned123
}
\description{
A binned dataset suitable for analysis by \code{\link{FitCorCbm}}. It was generated by
   \link{DfCreateCorCbmDataset} by setting the \code{seed} variable to 123. Note
   the formatting of the data as a single treatment two reader dataset, even though
   the actual pairing might be different, see \code{\link{FitCorCbm}}. The dataset is 
   intentionally large so as to demonstrate the asymptotic convergence of ML estimates, 
   produced by \code{\link{FitCorCbm}}, to the population values. The data was generated
   by the following argument values to \code{\link{DfCreateCorCbmDataset}}: seed = 123, 
   K1 = 5000, K2 = 5000, desiredNumBins = 5, muX = 1.5, muY = 3, alphaX = 0.4, 
   alphaY = 0.7, rhoNor = 0.3, rhoAbn2 = 0.8.
}
\examples{
str(datasetBinned123)

}
\references{
Zhai X, Chakraborty DP (2017). A bivariate contaminated binormal model for robust 
   fitting of proper ROC curves to a pair of correlated, possibly degenerate, 
   ROC datasets. Medical Physics. 44(6):2207--2222.
}
\keyword{datasets}
