% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StSignificanceTestingSingleFixedFactor.R
\name{StSignificanceTestingSingleFixedFactor}
\alias{StSignificanceTestingSingleFixedFactor}
\title{Perform significance testing for single fixed factor analysis}
\usage{
StSignificanceTestingSingleFixedFactor(dataset, FOM = "wAFROC",
  alpha = 0.05)
}
\arguments{
\item{dataset}{A single-treatment or single-reader dataset.}

\item{FOM}{The figure of merit, default  \code{"wAFROC"}, 
see \code{\link{UtilFigureOfMerit}}.}

\item{alpha}{The significance level (\code{alpha}, default 0.05) 
of the test of the null hypothesis that FOMs of all levels of 
the fixed factor are identical.}
}
\value{
The return value is a list containing:

\item{f}{The observed F-statistic for testing the null 
   hypothesis of no treatment effect.}

\item{ddf}{The denominator degrees of freedom of the F statistic. 
   The numerator degrees of freedom is always the number of levels of the 
   fixed factor minus one.}

\item{pValue}{The p-value for rejecting the NH.}

\item{fomStats}{Statistics for FOM for each level of the fixed factor.}

\item{diffFomStats}{Statistics for FOM-differences for all distinct 
   pairings of the levels of the fixed factor}
}
\description{
Significance testing for datasets with single reader in 
   multiple (at least two) treatments, or single treatment with multiple 
   (at least two) readers, where reader or treatment, respectively, is 
   regarded as a fixed factor and a common case-set, regarded as random, 
   is assumed.
}
\details{
This function performs implements Hillis et al. 2005, Eqn. 23. 
   Following an overall F-test, reader-pairings are compared using paired 
   t-tests. \strong{In order for a specific pairing to be declared 
   significant, the F-test must also be significant.}
}
\examples{
## Create a single treatment ROC dataset with one treatment and four readers
singleFactorData <- DfExtractDataset(dataset02, 1, 1:4)

## Performs single treatment fixed reader analysis
StSignificanceTestingSingleFixedFactor(singleFactorData, FOM = "Wilcoxon")

}
\references{
Hillis SL, Obuchowski NA, Schartz KM, Berbaum KS (2005) A comparison of the Dorfman-Berbaum-Metz and Obuchowski-Rockette methods for receiver operating characteristic (ROC) data, 
Statistics in Medicine, 24(10), 1579-607.

Hillis SL (2007) A comparison of denominator degrees of freedom methods 
for multiple observer ROC studies, Statistics in Medicine. 26:596-619.

Hillis SL (2014) A marginal mean ANOVA approach for analyzing multireader multicase radiological imaging data,
Statistics in medicine 33, 330-360.
}
