% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DfExtractDataset.R
\name{DfExtractDataset}
\alias{DfExtractDataset}
\title{Extract a subset of treatments and readers from a dataset}
\usage{
DfExtractDataset(dataset, trts, rdrs)
}
\arguments{
\item{dataset}{The original dataset from which the subset is to be extracted;
can be ROC, FROC or LROC}

\item{trts}{A vector contains the indices of the treatments to be extracted. 
\strong{If this parameter is not supplied, all treatments are extracted.}}

\item{rdrs}{A vector contains the indices of the readers to be extracted. 
\strong{If this parameter is not supplied, all readers are extracted.}}
}
\value{
A new dataset containing only the specified treatments and readers that were
extracted from the original dataset
}
\description{
Extract a dataset consisting of a subset of treatments/readers from a larger dataset
}
\details{
\strong{Note} that \code{trts} and \code{rdrs} are the vectors of \strong{indices} 
   not \strong{IDs}. For example, if the ID of the first reader is "0", the 
   corresponding value in \code{trts} should be \strong{1}  not \strong{0}.
}
\examples{
## Extract the data corresponding to the second reader in the 
## first treatment from an included ROC dataset
dataset1_2 <- DfExtractDataset(dataset05, trts = 1, rdrs = 2)

## Extract the data of the first and third reader in all 
## treatment from the included ROC dataset
datasetA_123 <- DfExtractDataset(dataset05, rdrs = c(1, 3))

}
