/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.util;

import java.io.IOException;
import java.io.Reader;

public class SafeLineReader
extends Reader {
    Reader reader;
    final char[] buffer = new char[8192];
    int bufferPos = 0;
    int bufferLen = 0;

    public SafeLineReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public synchronized int read(char[] cArray, int n, int n2) throws IOException {
        if (n2 >= this.bufferLen) {
            System.arraycopy(this.buffer, this.bufferPos, cArray, n, this.bufferLen);
            this.bufferPos = 0;
            this.bufferLen = 0;
            if (n2 == this.bufferLen) {
                return this.bufferLen;
            }
            return this.bufferLen + this.reader.read(cArray, n + this.bufferLen, n2 - this.bufferLen);
        }
        System.arraycopy(this.buffer, this.bufferPos, cArray, n, n2);
        this.bufferPos += n2;
        this.bufferLen -= n2;
        return n2;
    }

    public synchronized String readLine() throws IOException {
        StringBuilder stringBuilder = new StringBuilder(8192);
        boolean bl = false;
        int n = this.bufferPos;
        while (!bl && this.bufferLen > 0) {
            if (this.buffer[this.bufferPos] == '\n' || this.buffer[this.bufferPos] == '\r') {
                bl = true;
            }
            ++this.bufferPos;
            --this.bufferLen;
        }
        stringBuilder.append(this.buffer, n, this.bufferPos - n);
        if (!bl) {
            int n2 = 8192 - stringBuilder.length();
            this.bufferPos = 0;
            this.bufferLen = this.reader.read(this.buffer, 0, n2);
            while (!bl && this.bufferLen > 0) {
                if (this.buffer[this.bufferPos] == '\n' || this.buffer[this.bufferPos] == '\r') {
                    bl = true;
                }
                ++this.bufferPos;
                --this.bufferLen;
            }
            stringBuilder.append(this.buffer, n, this.bufferPos - n);
        }
        return stringBuilder.toString();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

