/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.api;

import it.bancaditalia.oss.sdmx.api.BaseObservation;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.exceptions.DataStructureException;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;

public class PortableDataSet<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TIME_LABEL = "TIME_PERIOD";
    public static final String OBS_LABEL = "OBS_VALUE";
    public static final String ID_LABEL = "ID";
    private static final String sourceClass = PortableDataSet.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();
    private boolean errorFlag = false;
    private boolean numeric = false;
    private String errorObjects = null;
    private DefaultTableModel model = new DefaultTableModel();

    public PortableDataSet() {
    }

    public <U extends T> PortableDataSet(List<PortableTimeSeries<U>> list) throws DataStructureException {
        this();
        this.setTimeSeries(list);
    }

    public int getColumnIndex(String string) throws DataStructureException {
        int n = this.model.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (!this.model.getColumnName(i).equals(string)) continue;
            return i;
        }
        throw new DataStructureException("Error: column " + string + " does not exist.");
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public String getColumnName(int n) throws DataStructureException {
        if (n >= 0 && n < this.getColumnCount()) {
            return this.model.getColumnName(n);
        }
        throw new DataStructureException("Error: index exceeds number of actual columns");
    }

    public Object getValueAt(int n, int n2) throws DataStructureException {
        if (n >= 0 && n2 >= 0 && n < this.getRowCount() && n2 < this.getColumnCount()) {
            return this.model.getValueAt(n, n2);
        }
        throw new DataStructureException("Error: index exceeds number of actual rows or columns");
    }

    public String[] getTimeStamps() throws DataStructureException {
        int n = this.getRowCount();
        String[] stringArray = new String[n];
        int n2 = this.getColumnIndex(TIME_LABEL);
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.getValueAt(i, n2);
        }
        return stringArray;
    }

    public Object[] getObservations() throws DataStructureException {
        int n = this.getRowCount();
        Object[] objectArray = new Object[n];
        int n2 = this.getColumnIndex(OBS_LABEL);
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.getValueAt(i, n2);
        }
        return objectArray;
    }

    public String[] getMetadata(String string) {
        int n = this.getRowCount();
        String[] stringArray = new String[n];
        try {
            int n2 = this.getColumnIndex(string);
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)this.getValueAt(i, n2);
            }
        }
        catch (DataStructureException dataStructureException) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public String[] getMetadataNames() throws DataStructureException {
        int n = this.getColumnCount();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            String string = this.getColumnName(i);
            if (string.equals(OBS_LABEL) || string.equals(TIME_LABEL)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    public <U> void setTimeSeries(List<PortableTimeSeries<U>> list) throws DataStructureException {
        logger.entering(sourceClass, "putTimeSeries");
        boolean bl = true;
        for (PortableTimeSeries<U> portableTimeSeries : list) {
            if (!bl || portableTimeSeries.isNumeric()) continue;
            bl = false;
        }
        for (PortableTimeSeries<U> portableTimeSeries : list) {
            this.putTimeSeries(portableTimeSeries, bl);
        }
        logger.exiting(sourceClass, "putTimeSeries");
    }

    public void addValue(int n, String string, Object object) throws DataStructureException {
        if (n >= this.model.getRowCount()) {
            this.model.setRowCount(n + 1);
        }
        int n2 = -1;
        try {
            n2 = this.getColumnIndex(string);
        }
        catch (DataStructureException dataStructureException) {
            this.model.addColumn(string);
            try {
                n2 = this.getColumnIndex(string);
            }
            catch (DataStructureException dataStructureException2) {
                logger.severe(dataStructureException2.getMessage());
                throw new DataStructureException("Unexpected error while adding column: " + string);
            }
        }
        this.model.setValueAt(object, n, n2);
    }

    public boolean isErrorFlag() {
        return this.errorFlag;
    }

    public void setErrorFlag(boolean bl) {
        this.errorFlag = bl;
    }

    public String getErrorObjects() {
        return this.errorObjects;
    }

    public void addErrorObjects(String string) {
        this.errorObjects = this.errorObjects == null || this.errorObjects.isEmpty() ? string : this.errorObjects + ", " + string;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public void setNumeric(boolean bl) {
        this.numeric = bl;
    }

    public String toString() {
        int n;
        int n2 = this.model.getRowCount();
        int n3 = this.model.getColumnCount();
        String string = "";
        for (n = 0; n < n3; ++n) {
            if (n != 0) {
                string = string + ";";
            }
            string = string + this.model.getColumnName(n);
        }
        string = string + "\n";
        for (n = 0; n < n2; ++n) {
            if (n != 0) {
                string = string + "\n";
            }
            for (int i = 0; i < n3; ++i) {
                if (i != 0) {
                    string = string + ";";
                }
                string = string + this.model.getValueAt(n, i);
            }
        }
        return string;
    }

    private void putTimeSeries(PortableTimeSeries<?> portableTimeSeries, boolean bl) throws DataStructureException {
        logger.entering(sourceClass, "putTimeSeries");
        int n = this.model.getRowCount();
        this.setNumeric(bl);
        Set<String> set = portableTimeSeries.getObsLevelAttributesNames();
        String string = portableTimeSeries.getName();
        if (portableTimeSeries.isErrorFlag()) {
            this.errorFlag = true;
            this.addErrorObjects(string);
        }
        for (BaseObservation<?> baseObservation : portableTimeSeries) {
            Object obj = bl && portableTimeSeries.isNumeric() ? Double.valueOf(baseObservation.getValueAsDouble()) : baseObservation.getValue();
            this.addValue(n, TIME_LABEL, baseObservation.getTimeslot());
            this.addValue(n, OBS_LABEL, obj);
            if (string != null && !string.isEmpty()) {
                this.addValue(n, ID_LABEL, string);
            }
            for (String string2 : set) {
                this.addValue(n, string2, baseObservation.getAttributeValue(string2));
            }
            for (Map.Entry entry : portableTimeSeries.getDimensionsMap().entrySet()) {
                this.addValue(n, (String)entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : portableTimeSeries.getAttributesMap().entrySet()) {
                this.addValue(n, (String)entry.getKey(), entry.getValue());
            }
            ++n;
        }
        logger.exiting(sourceClass, "putTimeSeries");
    }
}

