/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.DefaultX11Algorithm;
import ec.satoolkit.x11.IExtremeValuesCorrector;
import ec.satoolkit.x11.X11Exception;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.simplets.PeriodIterator;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.timeseries.simplets.YearIterator;

class DefaultExtremeValuesCorrector
extends DefaultX11Algorithm
implements IExtremeValuesCorrector {
    protected double lsigma = 1.5;
    protected double usigma = 2.5;
    protected double[] stdev;
    protected TsData scur;
    protected TsData scorr;
    protected TsData sweights;
    protected boolean isexcludefcast;
    private static final double EPS = 1.0E-15;
    private static final double EPS_STDEV = 1.0E-5;

    DefaultExtremeValuesCorrector() {
    }

    public static double[] periodAverages(TsData s) {
        int freq = s.getFrequency().intValue();
        double[] outs = new double[freq];
        PeriodIterator bi = new PeriodIterator(s);
        for (int i = 0; i < freq; ++i) {
            DataBlock bd = bi.nextElement().data;
            outs[i] = bd.sum() / (double)bd.getLength();
        }
        return outs;
    }

    @Override
    public int analyse(TsData s) {
        this.scur = s;
        this.sweights = null;
        this.scorr = null;
        TsData scurwithfcast = this.scur;
        this.scur = this.excludeforecast(this.scur);
        this.calcStdev();
        this.scur = scurwithfcast;
        int noutliers = this.outliersDetection();
        if (noutliers > 0) {
            this.removeExtremes();
            scurwithfcast = this.scur = this.scorr;
            this.scur = this.excludeforecast(this.scur);
            this.calcStdev();
            this.scur = scurwithfcast;
            this.scur = s;
            noutliers = this.outliersDetection();
        }
        return noutliers;
    }

    @Override
    public TsData applyCorrections(TsData sorig, TsData corrections) {
        TsData ns = sorig.clone();
        for (int i = 0; i < corrections.getLength(); ++i) {
            double x = corrections.get(i);
            if (Double.isNaN(x)) continue;
            ns.set(i, x);
        }
        return ns;
    }

    protected void calcStdev() {
        TsPeriod start = this.scur.getStart();
        TsPeriod end = this.scur.getLastPeriod();
        int y0 = start.getYear();
        int y1 = end.getYear();
        int ny = y1 - y0 + 1;
        int freq = this.scur.getFrequency().intValue();
        int nbeg = freq - start.getPosition();
        int nfy = ny;
        if (nbeg == freq) {
            nbeg = 0;
        } else {
            --nfy;
        }
        int nend = end.getPosition() + 1;
        if (nend == freq) {
            nend = 0;
        } else {
            --nfy;
        }
        DataBlock all = new DataBlock(this.scur.internalStorage());
        this.stdev = this.isexcludefcast ? new double[ny + 1] : new double[ny];
        if (nfy < 5) {
            double e = this.calcStdev(all);
            for (int i = 0; i < this.stdev.length; ++i) {
                this.stdev[i] = e;
            }
            return;
        }
        int ibeg = 2;
        if (nbeg > 0) {
            ++ibeg;
        }
        int iend = ibeg + nfy - 5;
        DataBlock cur = all.range(0, nbeg + 5 * freq);
        double e = this.calcStdev(cur);
        for (int i = 0; i < ibeg; ++i) {
            this.stdev[i] = e;
        }
        int pos = nbeg;
        while (ibeg <= iend) {
            cur = all.range(pos, pos + 5 * freq);
            this.stdev[ibeg++] = this.calcStdev(cur);
            pos += freq;
        }
        if (nend > 0) {
            cur = all.range(pos -= freq, this.scur.getLength());
            e = this.calcStdev(cur);
        } else {
            e = this.stdev[ibeg - 1];
        }
        for (int i = ibeg; i < this.stdev.length; ++i) {
            this.stdev[i] = e;
        }
    }

    protected double calcStdev(DataBlock data) {
        int n = data.getLength();
        int nm = 0;
        double e = 0.0;
        for (int i = 0; i < n; ++i) {
            double x = data.get(i);
            if (Double.isNaN(x)) {
                ++nm;
                continue;
            }
            if (this.isMultiplicative()) {
                x -= 1.0;
            }
            e += x * x;
        }
        return Math.sqrt(e / (double)(n - nm));
    }

    @Override
    public TsData computeCorrections(TsData s) {
        TsData ns = new TsData(s.getDomain());
        int n = ns.getLength();
        int beg = ns.getStart().getPosition();
        int freq = ns.getFrequency().intValue();
        double[] avgs = null;
        for (int i = 0; i < n; ++i) {
            int[] pos;
            double e = this.sweights.get(i);
            if (e == 1.0) {
                ns.set(i, Double.NaN);
                continue;
            }
            double x = e * s.get(i);
            if (s.getLength() < this.sweights.getLength()) {
                TsData tempsweights = this.sweights.clone();
                this.sweights = this.sweights.drop(0, this.sweights.getLength() - s.getLength());
                pos = this.searchPositionsForOutlierCorrection(i, freq);
                this.sweights = tempsweights;
            } else {
                pos = this.searchPositionsForOutlierCorrection(i, freq);
            }
            if (pos != null) {
                for (int k = 0; k < 4; ++k) {
                    x += s.get(pos[k]);
                }
                ns.set(i, x *= 1.0 / (4.0 + e));
                continue;
            }
            if (avgs == null) {
                avgs = DefaultExtremeValuesCorrector.periodAverages(s);
            }
            ns.set(i, avgs[(beg + i) % freq]);
        }
        return ns;
    }

    @Override
    public TsData getCorrectionFactors() {
        TsData ns = new TsData(this.scur.getDomain());
        ns.set(() -> this.context.getMean());
        for (int i = 0; i < this.sweights.getLength(); ++i) {
            double x = this.sweights.get(i);
            if (!(x < 1.0)) continue;
            double s = this.scur.get(i);
            if (this.context.isMultiplicative() || this.context.isPseudoAdditive()) {
                ns.set(i, s / (1.0 + x * (s - 1.0)));
                continue;
            }
            ns.set(i, s * (1.0 - x));
        }
        return ns;
    }

    @Override
    public TsData getObservationWeights() {
        return this.sweights;
    }

    public double[] getStandardDeviations() {
        return this.stdev;
    }

    protected int outliersDetection() {
        int nval = 0;
        this.sweights = new TsData(this.scur.getDomain());
        YearIterator iteri = new YearIterator(this.scur);
        YearIterator itero = new YearIterator(this.sweights);
        this.sweights.set(() -> 1.0);
        double xbar = this.getMean();
        int y = 0;
        while (iteri.hasMoreElements()) {
            double uv;
            double lv;
            boolean isNullStdev = false;
            if (y > this.stdev.length - 1) {
                lv = this.stdev[this.stdev.length - 1] * this.lsigma;
                uv = this.stdev[this.stdev.length - 1] * this.usigma;
                if (Math.abs(this.stdev[this.stdev.length - 1]) < 1.0E-5) {
                    isNullStdev = true;
                }
            } else {
                lv = this.stdev[y] * this.lsigma;
                uv = this.stdev[y] * this.usigma;
                if (Math.abs(this.stdev[y]) < 1.0E-5) {
                    isNullStdev = true;
                }
            }
            DataBlock dbi = iteri.nextElement().data;
            DataBlock dbo = itero.nextElement().data;
            if (!isNullStdev) {
                for (int i = 0; i < dbi.getLength(); ++i) {
                    double tt = Math.abs(dbi.get(i) - xbar);
                    if (tt - uv > 1.0E-15) {
                        dbo.set(i, 0.0);
                        ++nval;
                        continue;
                    }
                    if (!(tt - lv > 1.0E-15)) continue;
                    dbo.set(i, (uv - tt) / (uv - lv));
                }
            }
            ++y;
        }
        return nval;
    }

    private void removeExtremes() {
        this.scorr = this.scur.clone();
        for (int i = 0; i < this.sweights.getLength(); ++i) {
            if (this.sweights.get(i) != 0.0) continue;
            this.scorr.set(i, Double.NaN);
        }
    }

    private int[] searchPositionsForOutlierCorrection(int p, int frequency) {
        int lp = 0;
        int up = 0;
        int lb = p;
        int ub = p;
        int k = 0;
        int[] outs = new int[4];
        while (lb >= frequency && lp != 2) {
            if (this.sweights.get(lb -= frequency) != 1.0) continue;
            ++lp;
            outs[k++] = lb;
        }
        int len = this.sweights.getLength();
        while (ub < len - frequency && up != 2) {
            if (this.sweights.get(ub += frequency) != 1.0) continue;
            ++up;
            outs[k++] = ub;
        }
        if (lp < 2) {
            while (ub < len - frequency && k < 4) {
                if (this.sweights.get(ub += frequency) != 1.0) continue;
                ++lp;
                outs[k++] = ub;
            }
        } else if (up < 2) {
            while (lb >= frequency && k < 4) {
                if (this.sweights.get(lb -= frequency) != 1.0) continue;
                ++up;
                outs[k++] = lb;
            }
        }
        if (lp + up < 4) {
            return null;
        }
        return outs;
    }

    public double getLowerSigma() {
        return this.lsigma;
    }

    public double getUpperSigma() {
        return this.usigma;
    }

    @Override
    public void setSigma(double lsig, double usig) {
        if (usig <= lsig || lsig <= 0.5) {
            throw new X11Exception("Invalid sigma options");
        }
        this.lsigma = lsig;
        this.usigma = usig;
    }

    private TsData excludeforecast(TsData tsWithForcast) {
        if (this.isexcludefcast) {
            TsData tsWithoutforCast = tsWithForcast.drop(this.context.getBackcastHorizon(), this.context.getForecastHorizon());
            return tsWithoutforCast;
        }
        return tsWithForcast;
    }

    @Override
    public void setExcludefcast(boolean isExcludefcast) {
        this.isexcludefcast = isExcludefcast;
    }

    @Override
    public boolean getExcludefcast() {
        return this.isexcludefcast;
    }
}

