/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.dstats.F;
import ec.tstoolkit.dstats.ProbabilityType;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.modelling.RegStatus;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.tramo.AbstractTramoModule;
import ec.tstoolkit.sarima.estimation.GlsSarimaMonitor;
import ec.tstoolkit.timeseries.calendars.IGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.GregorianCalendarVariables;
import ec.tstoolkit.timeseries.regression.ICalendarVariable;
import ec.tstoolkit.timeseries.regression.IMovingHolidayVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.LeapYearVariable;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.regression.TsVariableSelection;
import java.util.Optional;

public class RegressionTestTD2
extends AbstractTramoModule
implements IPreprocessingModule {
    public static final double DEF_TVAL = 1.96;
    private final IGregorianCalendarProvider calendar;
    private final double pftd_;
    private double tval_ = 1.96;
    private static final String TD = "TD F-Test";
    private static final String REGS = "Regression variables";

    public RegressionTestTD2(IGregorianCalendarProvider calendar, double pftd) {
        this.pftd_ = pftd;
        this.calendar = calendar;
    }

    public double getPftd() {
        return this.pftd_;
    }

    public double getTValue() {
        return this.tval_;
    }

    public void setTvalue(double tval) {
        this.tval_ = tval;
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        ModelDescription all;
        if (!context.description.contains(var -> var.isCalendar() || var.isMovingHoliday())) {
            return ProcessingResult.Unprocessed;
        }
        ModelDescription test0 = this.createTestModel(context, TradingDaysType.None, LengthOfPeriodType.None);
        ModellingContext cxt0 = new ModellingContext();
        cxt0.description = test0;
        ModelEstimation regarima0 = new ModelEstimation(test0.buildRegArima());
        int nhp = test0.getArimaComponent().getFreeParametersCount();
        GlsSarimaMonitor monitor = this.getMonitor();
        regarima0.compute(monitor, nhp);
        cxt0.estimation = regarima0;
        Double SS0 = regarima0.getLikelihood().getSsqErr();
        Double SSmc0 = regarima0.getLikelihood().getSigma();
        if (!context.description.contains(var -> var.isCalendar())) {
            boolean mean = Math.abs(cxt0.estimation.getLikelihood().getTStats()[0]) > this.tval_;
            context.description = this.backModel(context, TradingDaysType.None, LengthOfPeriodType.None, this.checkEE(cxt0), mean);
            RegressionTestTD2.transferLogs(cxt0, context);
            return ProcessingResult.Changed;
        }
        ModelDescription test1 = this.createTestModel(context, TradingDaysType.TradingDays, LengthOfPeriodType.None);
        ModellingContext cxt1 = new ModellingContext();
        cxt1.description = test1;
        ModelEstimation regarima1 = new ModelEstimation(test1.buildRegArima());
        nhp = test1.getArimaComponent().getFreeParametersCount();
        regarima1.compute(monitor, nhp);
        cxt1.estimation = regarima1;
        ConcentratedLikelihood ll = cxt1.estimation.getLikelihood();
        double SS6 = regarima1.getLikelihood().getSsqErr();
        int df = ll.getN() - ll.getNx() - nhp;
        double SSmc6 = ll.getSsqErr() / (double)df;
        double Ftd = (SS0 - SS6) / (SSmc6 * 6.0);
        double pFtd6 = 0.0;
        if (Ftd >= 0.0) {
            F f0 = new F();
            f0.setDFDenom(df);
            f0.setDFNum(6);
            pFtd6 = f0.getProbability(Ftd, ProbabilityType.Lower);
        }
        ModelDescription test2 = this.createTestModel(context, TradingDaysType.WorkingDays, LengthOfPeriodType.None);
        ModellingContext cxt2 = new ModellingContext();
        cxt2.description = test2;
        ModelEstimation regarima2 = new ModelEstimation(test2.buildRegArima());
        nhp = test1.getArimaComponent().getFreeParametersCount();
        regarima2.compute(monitor, nhp);
        cxt2.estimation = regarima2;
        ll = cxt2.estimation.getLikelihood();
        double SS1 = cxt2.estimation.getLikelihood().getSsqErr();
        df = ll.getN() - ll.getNx() - nhp;
        double SSmc1 = ll.getSsqErr() / (double)df;
        Ftd = (SS0 - SS1) / SSmc1;
        double pFtd1 = 0.0;
        if (Ftd >= 0.0) {
            F f1 = new F();
            f1.setDFDenom(df);
            f1.setDFNum(1);
            pFtd1 = f1.getProbability(Ftd, ProbabilityType.Lower);
        }
        if (pFtd6 > pFtd1 && pFtd6 > 1.0 - this.pftd_) {
            this.addTDInfo(context, pFtd1, pFtd6, 6);
            cxt1.description = all = this.createTestModel(context, TradingDaysType.TradingDays, LengthOfPeriodType.LeapYear);
            ModelEstimation regarima = new ModelEstimation(all.buildRegArima());
            regarima.compute(monitor, nhp);
            cxt1.estimation = regarima;
            if (!this.checkLY(cxt1)) {
                boolean mean = Math.abs(cxt1.estimation.getLikelihood().getTStats()[0]) > this.tval_;
                context.description = this.backModel(context, TradingDaysType.TradingDays, LengthOfPeriodType.None, this.checkEE(cxt1), mean);
            } else {
                boolean mean = Math.abs(cxt1.estimation.getLikelihood().getTStats()[0]) > this.tval_;
                context.description = this.backModel(context, TradingDaysType.TradingDays, LengthOfPeriodType.LeapYear, this.checkEE(cxt1), mean);
            }
            RegressionTestTD2.transferLogs(cxt1, context);
        } else if (pFtd1 < 1.0 - this.pftd_) {
            this.addTDInfo(context, pFtd1, pFtd6, 0);
            boolean mean = Math.abs(cxt0.estimation.getLikelihood().getTStats()[0]) > this.tval_;
            context.description = this.backModel(context, TradingDaysType.None, LengthOfPeriodType.None, this.checkEE(cxt0), mean);
            RegressionTestTD2.transferLogs(cxt0, context);
        } else {
            this.addTDInfo(context, pFtd1, pFtd6, 1);
            cxt2.description = all = this.createTestModel(context, TradingDaysType.WorkingDays, LengthOfPeriodType.LeapYear);
            ModelEstimation regarima = new ModelEstimation(all.buildRegArima());
            regarima.compute(monitor, nhp);
            cxt2.estimation = regarima;
            if (!this.checkLY(cxt2)) {
                boolean mean = Math.abs(cxt2.estimation.getLikelihood().getTStats(true, 2)[0]) > this.tval_;
                context.description = this.backModel(context, TradingDaysType.WorkingDays, LengthOfPeriodType.None, this.checkEE(cxt2), mean);
            } else {
                boolean mean = Math.abs(cxt2.estimation.getLikelihood().getTStats(true, 2)[0]) > this.tval_;
                context.description = this.backModel(context, TradingDaysType.WorkingDays, LengthOfPeriodType.LeapYear, this.checkEE(cxt2), mean);
            }
            RegressionTestTD2.transferLogs(cxt2, context);
        }
        return ProcessingResult.Changed;
    }

    private ModelDescription createTestModel(ModellingContext context, TradingDaysType td, LengthOfPeriodType lp) {
        ModelDescription model = context.description.clone();
        model.setAirline(context.hasseas);
        model.setMean(true);
        model.setOutliers(null);
        model.removeVariable(var -> var.isCalendar());
        if (td != TradingDaysType.None) {
            model.addVariable(Variable.calendarVariable(new GregorianCalendarVariables(this.calendar, td), RegStatus.Accepted));
        }
        if (lp != LengthOfPeriodType.None) {
            model.addVariable(Variable.calendarVariable(new LeapYearVariable(lp), RegStatus.Accepted));
        }
        return model;
    }

    private ModelDescription backModel(ModellingContext context, TradingDaysType td, LengthOfPeriodType lp, boolean Ee, boolean mean) {
        ModelDescription model = context.description.clone();
        if (context.automodelling) {
            model.setMean(mean);
        }
        model.setOutliers(null);
        model.removeVariable(var -> var.isCalendar());
        if (!Ee) {
            model.removeVariable(var -> var.isMovingHoliday());
        } else {
            TsVariableList x = model.buildRegressionVariables();
            TsVariableSelection<ITsVariable> sel = x.selectCompatible(IMovingHolidayVariable.class);
            TsVariableSelection.Item<ITsVariable>[] items = sel.elements();
            for (int i = 0; i < items.length; ++i) {
                Variable search = model.searchVariable((ITsVariable)items[i].variable);
                if (!search.status.needTesting()) continue;
                search.status = RegStatus.Accepted;
            }
        }
        if (td != TradingDaysType.None) {
            GregorianCalendarVariables vars = this.tdvars(context);
            vars.setDayOfWeek(td);
            model.addVariable(Variable.calendarVariable(vars, RegStatus.Accepted));
        }
        if (lp != LengthOfPeriodType.None) {
            model.addVariable(Variable.calendarVariable(new LeapYearVariable(lp), RegStatus.Accepted));
        }
        return model;
    }

    private GregorianCalendarVariables tdvars(ModellingContext context) {
        Optional<Variable> found = context.description.variables().filter(var -> var.isCompatible(GregorianCalendarVariables.class)).findFirst();
        if (found.isPresent()) {
            return ((GregorianCalendarVariables)found.get().getVariable()).clone();
        }
        return new GregorianCalendarVariables(this.calendar, TradingDaysType.None);
    }

    private boolean checkLY(ModellingContext model) {
        boolean retval = true;
        ConcentratedLikelihood ll = model.estimation.getLikelihood();
        int start = model.description.getRegressionVariablesStartingPosition();
        TsVariableList x = model.description.buildRegressionVariables();
        TsVariableSelection<ITsVariable> sel = x.selectCompatible(ICalendarVariable.class);
        TsVariableSelection.Item<ITsVariable>[] items = sel.elements();
        double[] Tstat = ll.getTStats(true, 2);
        double t = Tstat[start + items[items.length - 1].position];
        if (Math.abs(t) < 2.0) {
            this.addLPInfo(model, t);
            retval = false;
        }
        return retval;
    }

    private boolean checkEE(ModellingContext model) {
        boolean retval = true;
        if (!model.description.contains(var -> var.isMovingHoliday())) {
            return false;
        }
        TsVariableList x = model.description.buildRegressionVariables();
        TsVariableSelection<ITsVariable> sel = x.selectCompatible(IMovingHolidayVariable.class);
        if (sel.isEmpty()) {
            return false;
        }
        TsVariableSelection.Item<ITsVariable>[] items = sel.elements();
        Variable search = model.description.searchVariable((ITsVariable)items[items.length - 1].variable);
        if (search == null) {
            return false;
        }
        if (!search.status.needTesting()) {
            return true;
        }
        ConcentratedLikelihood ll = model.estimation.getLikelihood();
        int start = model.description.getRegressionVariablesStartingPosition();
        double[] Tstat = ll.getTStats(true, 2);
        double t = Tstat[start + items[items.length - 1].position];
        if (Math.abs(t) < 2.2) {
            this.addEasterInfo(model, t);
            retval = false;
        }
        return retval;
    }

    private void addLPInfo(ModellingContext context, double tstat) {
    }

    private void addEasterInfo(ModellingContext context, double tstat) {
    }

    private void addTDInfo(ModellingContext context, double pwd, double ptd, int sel) {
    }
}

