/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.matrices.EigenRoutines;
import ec.tstoolkit.maths.matrices.EigenSystem;
import ec.tstoolkit.maths.matrices.IEigenSystem;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;

class GeneralEigenSystem
implements IEigenSystem {
    private Matrix m_std;
    private Complex[] m_ev;
    private double m_zero = 1.0E-6;
    private int m_maxiter = 30;
    private boolean m_bCalc = false;
    private boolean m_bVec = false;

    public GeneralEigenSystem(Matrix im) {
        this.m_std = im.clone();
    }

    @Override
    public void compute() {
        this.m_bCalc = false;
        this.calc();
    }

    @Override
    public Complex[] getEigenValues() {
        this.calc();
        int n = this.m_std.getRowsCount();
        Complex[] rout = new Complex[n];
        System.arraycopy(this.m_ev, 0, rout, 0, rout.length);
        return rout;
    }

    @Override
    public Complex[] getEigenValues(int m) {
        this.calc();
        int n = this.m_std.getRowsCount();
        int mel = Math.min(n, m);
        Complex[] rout = new Complex[mel];
        System.arraycopy(this.m_ev, 0, rout, 0, mel);
        return rout;
    }

    @Override
    public double[] getEigenVector(int idx) {
        throw new MatrixException("err_notimpl");
    }

    @Override
    public Matrix getEigenVectors() {
        throw new MatrixException("err_notimpl");
    }

    @Override
    public Matrix getEigenVectors(int m) {
        throw new MatrixException("err_notimpl");
    }

    @Override
    public double getZero() {
        return this.m_zero;
    }

    @Override
    public void setZero(double value) {
        this.m_zero = value;
    }

    public int getMaxIter() {
        return this.m_maxiter;
    }

    public void setMaxIter(int value) {
        this.m_maxiter = value;
    }

    @Override
    public boolean isComputingEigenVectors() {
        return this.m_bVec;
    }

    @Override
    public void setComputingEigenVectors(boolean value) {
        this.m_bVec = value;
    }

    void calc() {
        if (this.m_bCalc) {
            return;
        }
        EigenRoutines.setMaxIter(this.m_maxiter);
        double[] data = EigenSystem.convertToArray(this.m_std);
        EigenRoutines.balance(data, this.m_std.getRowsCount());
        EigenRoutines.hessenberg(data, this.m_std.getRowsCount());
        this.m_ev = EigenRoutines.hessenbergQR(data, this.m_std.getRowsCount());
        this.m_bCalc = true;
    }
}

