/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.BaseException;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.ArmaEvaluation;
import ec.tstoolkit.arima.estimation.ArmaFunction;
import ec.tstoolkit.arima.estimation.IArmaFilter;
import ec.tstoolkit.arima.estimation.IRegArimaProcessor;
import ec.tstoolkit.arima.estimation.KalmanFilter;
import ec.tstoolkit.arima.estimation.ModifiedLjungBoxFilter;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.realfunctions.IFunctionDerivatives;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.maths.realfunctions.IFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionDerivatives;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionInstance;
import ec.tstoolkit.maths.realfunctions.ProxyMinimizer;
import ec.tstoolkit.maths.realfunctions.levmar.LevenbergMarquardtMethod;

public class GlsArimaMonitor<S extends IArimaModel>
implements IRegArimaProcessor<S> {
    private IArmaFilter m_filter1 = new KalmanFilter(false);
    private IArmaFilter m_filter2 = new KalmanFilter(true);
    private int m_flimit = 1;
    private boolean m_ml = true;
    private boolean m_llog = false;
    private boolean m_mt = false;
    private IFunctionMinimizer m_min = null;
    private IParametricMapping<S> m_mapper;
    private boolean m_bconverged;
    private ArmaFunction<S> m_fn;
    private ArmaEvaluation<S> m_efn;
    private Matrix m_information;
    private Matrix m_curvature;
    private double[] m_score;
    private double m_obj;
    private double m_precision = 1.0E-7;

    public IArmaFilter getFilter1() {
        return this.m_filter1;
    }

    public IArmaFilter getFilter2() {
        return this.m_filter2;
    }

    public int getFilterLimit() {
        return this.m_flimit;
    }

    public IParametricMapping<S> getMapping() {
        return this.m_mapper;
    }

    public IFunctionMinimizer getMinimizer() {
        return this.m_min;
    }

    @Override
    public double getPrecision() {
        return this.m_precision;
    }

    public double[] getScore() {
        return this.m_score;
    }

    public boolean hasConverged() {
        return this.m_bconverged;
    }

    public Matrix getObservedInformation(int ndf) {
        if (this.m_efn == null) {
            return null;
        }
        if (this.m_information == null) {
            try {
                DataBlock res = this.m_efn.fn.dmodel.calcRes(new ReadDataBlock(this.m_efn.getLikelihood().getB()));
                RegModel Y = new RegModel();
                Y.setY(res);
                if (this.m_efn.fn.missings != null) {
                    for (int i = 0; i < this.m_efn.fn.missings.length; ++i) {
                        Y.addX(this.m_efn.fn.dmodel.X(i));
                    }
                }
                ArmaFunction fn = new ArmaFunction(Y, this.m_efn.fn.d, this.m_efn.fn.missings, this.m_efn.fn.mapper);
                fn.llog = this.m_llog;
                fn.filter = new ModifiedLjungBoxFilter();
                IFunctionInstance eval = fn.evaluate(this.m_efn.getParameters());
                if (!this.m_llog) {
                    ISsqFunctionDerivatives derivatives = fn.getDerivatives((ISsqFunctionInstance)((Object)eval));
                    this.m_information = derivatives.getHessian();
                    this.m_score = derivatives.getGradient();
                    this.m_information.mul(0.5 * (double)ndf / ((ArmaEvaluation)eval).getSsqE());
                    int i = 0;
                    while (i < this.m_score.length) {
                        int n = i++;
                        this.m_score[n] = this.m_score[n] * (-0.5 * (double)ndf / ((ArmaEvaluation)eval).getSsqE());
                    }
                } else {
                    IFunctionDerivatives derivatives = fn.getDerivatives(eval);
                    this.m_information = derivatives.getHessian();
                    this.m_score = derivatives.getGradient();
                    for (int i = 0; i < this.m_score.length; ++i) {
                        this.m_score[i] = -this.m_score[i];
                    }
                }
            }
            catch (Exception err) {
                if (this.m_curvature != null) {
                    this.m_information = this.m_curvature.clone();
                    if (!this.m_llog) {
                        this.m_information.mul(0.5 * (double)ndf / this.m_obj);
                        int i = 0;
                        while (i < this.m_score.length) {
                            int n = i++;
                            this.m_score[n] = this.m_score[n] * (-0.5 * (double)ndf / this.m_obj);
                        }
                    } else {
                        for (int i = 0; i < this.m_score.length; ++i) {
                            this.m_score[i] = -this.m_score[i];
                        }
                    }
                }
            }
        }
        return this.m_information;
    }

    public double getMinimum() {
        return this.m_obj;
    }

    public S initialize(RegArimaModel<S> regs) {
        this.clear();
        return null;
    }

    public boolean isUsingLogLikelihood() {
        return this.m_llog;
    }

    public boolean isUsingMaximumLikelihood() {
        return this.m_ml;
    }

    public boolean isMultiThread() {
        return this.m_mt;
    }

    public void setMultiThread(boolean mt) {
        this.m_mt = mt;
    }

    @Override
    public RegArimaEstimation<S> optimize(RegArimaModel<S> regs) {
        return this.optimize(regs, regs.getArma());
    }

    public RegArimaEstimation<S> optimize(RegArimaModel<S> regs, S start) {
        this.clear();
        if (this.m_mapper.getDim() == 0) {
            return new RegArimaEstimation<S>(regs, regs.computeLikelihood());
        }
        try {
            IFunctionMinimizer fmin;
            if (this.m_min != null) {
                fmin = this.m_min.exemplar();
                fmin.setConvergenceCriterion(this.m_precision);
            } else {
                fmin = new ProxyMinimizer(new LevenbergMarquardtMethod());
                fmin.setConvergenceCriterion(this.m_precision);
                this.m_llog = false;
            }
            S arma = start;
            if (arma == null) {
                arma = regs.getArma();
            }
            this.m_fn = new ArmaFunction<S>(regs.getDModel(), regs.getArima().getNonStationaryARCount(), regs.getMissings(), this.m_mapper);
            this.m_fn.mt = this.m_mt;
            this.m_fn.filter = regs.getVarsCount() > this.m_flimit ? this.m_filter2 : this.m_filter1;
            this.m_fn.ml = this.m_ml;
            this.m_fn.llog = this.m_llog;
            ArmaEvaluation<S> fstart = new ArmaEvaluation<S>(this.m_fn, arma);
            this.m_bconverged = fmin.minimize(this.m_fn, fstart);
            this.m_efn = (ArmaEvaluation)fmin.getResult();
            RegArimaModel<RegArimaModel<S>> nregs = new RegArimaModel<RegArimaModel<S>>(regs);
            IArimaModel narima = (IArimaModel)this.m_mapper.map(this.m_efn.getParameters());
            if (narima != null) {
                nregs.setArima((RegArimaModel<S>)((Object)narima));
            }
            RegArimaEstimation<RegArimaModel<S>> rslt = new RegArimaEstimation<RegArimaModel<S>>(nregs, this.m_efn.getLikelihood());
            this.m_obj = fmin.getObjective();
            this.m_curvature = fmin.getCurvature();
            this.m_score = fmin.getGradient();
            return rslt;
        }
        catch (BaseException ex) {
            return null;
        }
    }

    @Override
    public RegArimaEstimation<S> process(RegArimaModel<S> regs) {
        S start = this.initialize(regs);
        return this.optimize(regs, start);
    }

    public void setFilter1(IArmaFilter value) {
        this.m_filter1 = value;
    }

    public void setFilter2(IArmaFilter value) {
        this.m_filter2 = value;
    }

    public void setFilterLimit(int value) {
        this.m_flimit = value;
    }

    public void setMapping(IParametricMapping<S> value) {
        this.m_mapper = value;
    }

    public void setMinimizer(IFunctionMinimizer value) {
        this.m_min = value;
        if (this.m_min != null) {
            this.m_min.setConvergenceCriterion(this.m_precision);
        }
    }

    @Override
    public void setPrecision(double value) {
        this.m_precision = value;
        if (this.m_min != null) {
            this.m_min.setConvergenceCriterion(value);
        }
    }

    public void useLogLikelihood(boolean value) {
        this.m_llog = value;
    }

    public void useMaximumLikelihood(boolean value) {
        this.m_ml = value;
    }

    private void clear() {
        this.m_obj = Double.NaN;
        this.m_information = null;
        this.m_curvature = null;
        this.m_score = null;
        this.m_fn = null;
        this.m_efn = null;
    }
}

