/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.ITaper;
import ec.tstoolkit.data.Periodogram;
import ec.tstoolkit.data.WindowType;
import ec.tstoolkit.dstats.Normal;
import ec.tstoolkit.dstats.TestType;
import ec.tstoolkit.stats.StatisticalTest;

public class BlackmanTukeySpectrum {
    private static final int MIN_CORR = 1;
    private double[] data_;
    private double[] cov_;
    private double[] spect_;
    private WindowType win_ = WindowType.Tukey;
    private int winLen_ = 44;
    private ITaper taper_;

    private boolean calc() {
        this.spect_ = null;
        if (this.data_ == null || this.winLen_ < 0 || this.winLen_ >= this.data_.length) {
            return false;
        }
        if (!this.meanCorrection()) {
            return false;
        }
        if (!this.taping()) {
            return false;
        }
        this.computeCov();
        this.computeSpectrum();
        return true;
    }

    public void setData(double[] data) {
        this.data_ = (double[])data.clone();
        this.clear();
    }

    public double[] getData() {
        return this.data_;
    }

    public int getWindowLength() {
        return this.winLen_;
    }

    public void setWindowLength(int wlen) {
        this.winLen_ = wlen;
        this.spect_ = null;
    }

    public ITaper getTaper() {
        return this.taper_;
    }

    public void setTaper(ITaper taper) {
        this.taper_ = taper;
        this.clear();
    }

    public WindowType getWindowType() {
        return this.win_;
    }

    public void setWindowType(WindowType wtype) {
        this.win_ = wtype;
        this.spect_ = null;
    }

    public double getAutoCovariances(int lag) {
        this.computeCov();
        return this.cov_[lag];
    }

    public double[] getSpectrum() {
        if (this.spect_ == null) {
            this.calc();
        }
        return this.spect_;
    }

    public double getSpectrumValue(double freq) {
        if (this.spect_ == null && !this.calc()) {
            return Double.NaN;
        }
        int ipos = (int)Math.round(freq * (double)this.winLen_ / (Math.PI * 2));
        if (ipos == this.spect_.length) {
            ipos = this.spect_.length - 1;
        }
        if (ipos < 0 || ipos >= this.spect_.length) {
            return Double.NaN;
        }
        return this.spect_[ipos];
    }

    public double getAverageSpectrum(double[] freqs) {
        if (this.spect_ == null && !this.calc()) {
            return Double.NaN;
        }
        double w2 = this.winLen_ / 2;
        double s = 0.0;
        for (int i = 0; i < freqs.length; ++i) {
            int ipos = -1 + (int)Math.round(freqs[i] * w2 / Math.PI);
            if (ipos >= this.spect_.length) {
                ipos = this.spect_.length - 1;
            } else if (ipos < 0) {
                ipos = 0;
            }
            s += this.spect_[ipos];
        }
        return s / (double)freqs.length;
    }

    public StatisticalTest getAverageSpectrumTest(int ifreq) {
        double e = 4.0 * ((double)this.winLen_ - 2.0) / (double)(this.data_.length * ifreq);
        Normal N = new Normal();
        N.setMean(1.0);
        N.setStdev(Math.sqrt(e));
        double val = this.getAverageSpectrum(Periodogram.getSeasonalFrequencies(ifreq));
        return new StatisticalTest(N, val, TestType.Upper, true);
    }

    public double[] window() {
        return this.win_.window(this.winLen_);
    }

    public void computeSpectrum() {
        int i;
        double[] cwnd = this.window();
        int nspect_ = 1 + this.winLen_ / 2;
        this.spect_ = new double[nspect_];
        for (i = 0; i < this.winLen_; ++i) {
            int n = i;
            cwnd[n] = cwnd[n] * this.cov_[i];
        }
        for (i = 0; i < nspect_; ++i) {
            double s = cwnd[0];
            for (int j = 1; j < this.winLen_; ++j) {
                s += 2.0 * cwnd[j] * Math.cos(Math.PI * 2 * (double)i * (double)j / (double)this.winLen_);
            }
            if (s < 0.0) {
                s = 0.0;
            }
            this.spect_[i] = s / this.cov_[0];
        }
    }

    private void clear() {
        this.cov_ = null;
        this.spect_ = null;
    }

    private void computeCov() {
        int lstart;
        if (this.data_ == null || this.winLen_ < 0) {
            return;
        }
        if (this.cov_ != null && this.cov_.length > this.winLen_) {
            return;
        }
        if (this.cov_ != null) {
            lstart = this.cov_.length;
            double[] tmp = new double[this.winLen_ + 1];
            System.arraycopy(this.cov_, 0, tmp, 0, lstart);
            this.cov_ = tmp;
        } else {
            lstart = 0;
            this.cov_ = new double[this.winLen_];
        }
        for (int i = lstart; i < this.winLen_; ++i) {
            this.cov_[i] = DescriptiveStatistics.cov(i, this.data_);
        }
    }

    private boolean meanCorrection() {
        DescriptiveStatistics ds = new DescriptiveStatistics(this.data_);
        if (ds.getObservationsCount() < this.minSize()) {
            return false;
        }
        if (ds.getDataCount() < this.winLen_ + this.minCorr()) {
            return false;
        }
        double m = ds.getAverage();
        if (m != 0.0) {
            for (int i = 0; i < this.data_.length; ++i) {
                if (!Double.isFinite(this.data_[i])) continue;
                int n = i;
                this.data_[n] = this.data_[n] - m;
            }
        }
        return true;
    }

    private boolean taping() {
        if (this.taper_ == null) {
            return true;
        }
        this.taper_.process(this.data_);
        return true;
    }

    private int minSize() {
        return 10;
    }

    private int minCorr() {
        return 1;
    }

    public boolean isValid() {
        if (this.spect_ == null) {
            return this.calc();
        }
        return true;
    }
}

