% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pandoc.R
\name{get_Pandoc}
\alias{get_Pandoc}
\title{Downloads Pandoc}
\usage{
get_Pandoc(app_dir, Pandoc_version = rmarkdown::pandoc_version())
}
\arguments{
\item{app_dir}{Shiny app's directory, defaults to \code{getwd()}.}

\item{Pandoc_version}{Pandoc version to use, defaults to: \code{\link[rmarkdown]{pandoc_version}}. This ensures that the same version of Pandoc used during development is installed on users' computers.}
}
\value{
\code{sprintf("pandoc-\%s-windows.msi", Pandoc_version)} in \code{app_dir}.
}
\description{
Downloads Pandoc in \code{app_dir}. If Pandoc has already been downloaded, \code{get_Pandoc} will use that file. If the download fails it will stop.
}
\details{
If \code{\link{create_app}(include_Pandoc = TRUE)}, then \code{get_Pandoc}.
}
\seealso{
\code{\link{get_R}}, \code{\link{copy_installation}}, \code{\link{create_config}}, \code{\link{create_bat}}, \code{\link{directives}}, \code{\link{setup}}, \code{\link{languages}}, \code{\link{tasks}}, \code{\link{files}}, \code{\link{icons}}, \code{\link{run}}, and \code{\link{code}}.
}
\author{
Jonathan M. Hill and Hanjo Odendaal
}
