/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.ImagePlus;
import ij.plugin.LZWEncoder;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class GifEncoder {
    int width;
    int height;
    boolean transparent;
    int transIndex;
    int repeat = 0;
    protected int delay = 50;
    boolean started = false;
    OutputStream out;
    ImagePlus image;
    byte[] pixels;
    byte[] indexedPixels;
    int colorDepth;
    byte[] colorTab;
    int lctSize = 7;
    int dispose = 0;
    boolean closeStream = false;
    boolean firstFrame = true;
    boolean sizeSet = false;
    int sample = 2;
    byte[] gct = null;
    boolean GCTextracted = false;
    boolean GCTloadedExternal = false;
    int GCTred = 0;
    int GCTgrn = 0;
    int GCTbl = 0;
    int GCTcindex = 0;
    boolean GCTsetTransparent = false;
    boolean GCToverideIndex = false;
    boolean GCToverideColor = false;

    GifEncoder() {
    }

    public boolean addFrame(ImagePlus imagePlus) {
        if (imagePlus == null || !this.started) {
            return false;
        }
        boolean bl = true;
        try {
            if (this.firstFrame) {
                if (!this.sizeSet) {
                    this.setSize(imagePlus.getWidth(), imagePlus.getHeight());
                }
                this.writeLSD();
                if (this.repeat >= 0) {
                    this.writeNetscapeExt();
                }
                this.firstFrame = false;
            }
            int n = imagePlus.getBitDepth();
            this.Process8bitCLT(imagePlus);
            this.writeGraphicCtrlExt();
            this.writeImageDesc();
            this.writePalette();
            this.writePixels();
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    void Process8bitCLT(ImagePlus imagePlus) {
        this.colorDepth = 8;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        imageProcessor = imageProcessor.convertToByte(true);
        ColorModel colorModel = imageProcessor.getColorModel();
        this.indexedPixels = (byte[])imageProcessor.getPixels();
        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
        int n = indexColorModel.getMapSize();
        if (this.transIndex >= n) {
            this.setTransparent(false);
            this.transIndex = 0;
        }
        this.colorTab = new byte[n * 3];
        for (int i = 0; i < n; ++i) {
            int n2 = i * 3;
            this.colorTab[n2] = (byte)indexColorModel.getRed(i);
            this.colorTab[n2 + 1] = (byte)indexColorModel.getGreen(i);
            this.colorTab[n2 + 2] = (byte)indexColorModel.getBlue(i);
        }
        indexColorModel.finalize();
    }

    public boolean finish() {
        if (!this.started) {
            return false;
        }
        boolean bl = true;
        this.started = false;
        try {
            this.out.write(59);
            this.out.flush();
            if (this.closeStream) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.GCTextracted = false;
        this.GCTloadedExternal = false;
        this.transIndex = 0;
        this.transparent = false;
        this.gct = null;
        this.out = null;
        this.image = null;
        this.pixels = null;
        this.indexedPixels = null;
        this.colorTab = null;
        this.closeStream = false;
        this.firstFrame = true;
        return bl;
    }

    public void setDelay(int n) {
        this.delay = Math.round((float)n / 10.0f);
    }

    public void setDispose(int n) {
        if (n >= 0) {
            this.dispose = n;
        }
    }

    public void setFrameRate(float f) {
        if (f != 0.0f) {
            this.delay = Math.round(100.0f / f);
        }
    }

    public void setQuality(int n) {
        if (n < 1) {
            n = 1;
        }
        this.sample = n;
    }

    public void setRepeat(int n) {
        if (n >= 0) {
            this.repeat = n;
        }
    }

    public void setSize(int n, int n2) {
        if (this.started && !this.firstFrame) {
            return;
        }
        this.width = n;
        this.height = n2;
        if (this.width < 1) {
            this.width = 320;
        }
        if (this.height < 1) {
            this.height = 240;
        }
        this.sizeSet = true;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    public boolean start(OutputStream outputStream) {
        if (outputStream == null) {
            return false;
        }
        boolean bl = true;
        this.closeStream = false;
        this.out = outputStream;
        try {
            this.writeString("GIF89a");
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.started = bl;
        return this.started;
    }

    public boolean start(String string) {
        boolean bl = true;
        try {
            this.out = new BufferedOutputStream(new FileOutputStream(string));
            bl = this.start(this.out);
            this.closeStream = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.started = bl;
        return this.started;
    }

    public void OverRideQuality(int n) {
        this.sample = n > 100000 ? 10 : n / 10000;
        if (this.sample < 1) {
            this.sample = 1;
        }
    }

    protected void writeGraphicCtrlExt() throws IOException {
        int n;
        int n2;
        this.out.write(33);
        this.out.write(249);
        this.out.write(4);
        if (!this.transparent) {
            n2 = 0;
            n = 0;
        } else {
            n2 = 1;
            n = 2;
        }
        if (this.dispose >= 0) {
            n = this.dispose & 7;
        }
        this.out.write(0 | (n <<= 2) | 0 | n2);
        this.writeShort(this.delay);
        this.out.write(this.transIndex);
        this.out.write(0);
    }

    protected void writeImageDesc() throws IOException {
        this.out.write(44);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(0x80 | this.lctSize);
    }

    protected void writeLSDgct() throws IOException {
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(0xF0 | this.lctSize);
        this.out.write(0);
        this.out.write(0);
    }

    protected void writeLSD() throws IOException {
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(112);
        this.out.write(0);
        this.out.write(0);
    }

    protected void writeNetscapeExt() throws IOException {
        this.out.write(33);
        this.out.write(255);
        this.out.write(11);
        this.writeString("NETSCAPE2.0");
        this.out.write(3);
        this.out.write(1);
        this.writeShort(this.repeat);
        this.out.write(0);
    }

    protected void writePalette() throws IOException {
        this.out.write(this.colorTab, 0, this.colorTab.length);
        int n = 768 - this.colorTab.length;
        for (int i = 0; i < n; ++i) {
            this.out.write(0);
        }
    }

    protected void writePixels() throws IOException {
        LZWEncoder lZWEncoder = new LZWEncoder(this.width, this.height, this.indexedPixels, this.colorDepth);
        lZWEncoder.encode(this.out);
    }

    protected void writeShort(int n) throws IOException {
        this.out.write(n & 0xFF);
        this.out.write(n >> 8 & 0xFF);
    }

    protected void writeString(String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            this.out.write((byte)string.charAt(i));
        }
    }
}

