/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.PopupMenu;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class PopupMenuBar
extends MenuBar {
    private Vector menus = new Vector();
    Menu helpMenu;
    private int[] widths;
    private boolean calculated = false;

    public PopupMenuBar() {
        this.setFont(new Font("SansSerif", 0, 12));
    }

    public void setFont(Font font) {
        this.calculated = false;
        super.setFont(font);
    }

    public Menu getHelpMenu() {
        return this.helpMenu;
    }

    public void setHelpMenu(Menu menu) {
        this.calculated = false;
        if (!(menu instanceof PopupMenu)) {
            throw new RuntimeException("IJMenuBar needs PopupMenus");
        }
        this.helpMenu = menu;
    }

    public Menu add(Menu menu) {
        this.calculated = false;
        if (!(menu instanceof PopupMenu)) {
            throw new RuntimeException("IJMenuBar needs PopupMenus(offending menu: " + menu.getLabel() + ")");
        }
        this.menus.add(menu);
        return menu;
    }

    public void remove(int n) {
        this.calculated = false;
        this.menus.remove(n);
    }

    public Menu getMenu(int n) {
        if (n >= this.menus.size()) {
            return this.helpMenu;
        }
        return (Menu)this.menus.get(n);
    }

    public int getMenuCount() {
        return this.menus.size() + (this.helpMenu != null ? 1 : 0);
    }

    int[] calculateWidths(Component component, Graphics graphics) {
        if (this.calculated) {
            return this.widths;
        }
        this.widths = new int[this.getMenuCount()];
        FontMetrics fontMetrics = component.getFontMetrics(this.getFont());
        for (int i = 0; i < this.widths.length; ++i) {
            String string = this.getMenu(i).getLabel();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            this.widths[i] = (int)Math.round(rectangle2D.getWidth());
        }
        this.calculated = true;
        return this.widths;
    }

    int[] getWidths() {
        return this.widths;
    }
}

