/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Roi;
import ij.io.OpenDialog;
import ij.io.RoiDecoder;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;

public class RoiReader
implements PlugIn {
    final int polygon = 0;
    final int rect = 1;
    final int oval = 2;
    final int line = 3;
    final int freeLine = 4;
    final int segLine = 5;
    final int noRoi = 6;
    final int freehand = 7;
    final int traced = 8;

    public void run(String arg) {
        OpenDialog od = new OpenDialog("Open ROI...", arg);
        String dir = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        try {
            this.openRoi(dir, name);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.error("ROI Reader", msg);
        }
    }

    public void openRoi(String dir, String name) throws IOException {
        String path = dir + name;
        RoiDecoder rd = new RoiDecoder(path);
        Roi roi = rd.getRoi();
        Rectangle r = roi.getBounds();
        ImagePlus img = WindowManager.getCurrentImage();
        if (img == null || img.getWidth() < r.x + r.width || img.getHeight() < r.y + r.height) {
            ByteProcessor ip = new ByteProcessor(r.x + r.width + 10, r.y + r.height + 10);
            ((ImageProcessor)ip).setColor(Color.white);
            ip.fill();
            img = new ImagePlus(name, ip);
            img.show();
        }
        img.setRoi(roi);
    }
}

