/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.table.Column;
import org.h2.util.ObjectArray;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueResultSet;

public class Call
extends Prepared {
    private Expression value;
    private ObjectArray<Expression> expressions;

    public Call(Session session) {
        super(session);
    }

    public ResultInterface queryMeta() throws SQLException {
        LocalResult localResult = new LocalResult(this.session, this.expressions, 1);
        localResult.done();
        return localResult;
    }

    public int update() throws SQLException {
        Value value = this.value.getValue(this.session);
        int n = value.getType();
        switch (n) {
            case 17: 
            case 18: {
                return super.update();
            }
            case -1: 
            case 0: {
                return 0;
            }
        }
        return value.getInt();
    }

    public ResultInterface query(int n) throws SQLException {
        this.setCurrentRowNumber(1);
        Value value = this.value.getValue(this.session);
        if (value.getType() == 18) {
            ResultSet resultSet = ((ValueResultSet)value).getResultSet();
            return LocalResult.read(this.session, resultSet, n);
        }
        if (value.getType() == 17) {
            Value[] valueArray = ((ValueArray)value).getList();
            ObjectArray<Expression> objectArray = ObjectArray.newInstance();
            for (int i = 0; i < valueArray.length; ++i) {
                Value value2 = valueArray[i];
                Column column = new Column("C" + (i + 1), value2.getType(), value2.getPrecision(), value2.getScale(), value2.getDisplaySize());
                objectArray.add(new ExpressionColumn(this.session.getDatabase(), column));
            }
            LocalResult localResult = new LocalResult(this.session, objectArray, valueArray.length);
            localResult.addRow(valueArray);
            localResult.done();
            return localResult;
        }
        LocalResult localResult = new LocalResult(this.session, this.expressions, 1);
        Value[] valueArray = new Value[]{value};
        localResult.addRow(valueArray);
        localResult.done();
        return localResult;
    }

    public void prepare() throws SQLException {
        this.value = this.value.optimize(this.session);
        this.expressions = ObjectArray.newInstance();
        this.expressions.add(this.value);
    }

    public void setValue(Expression expression) {
        this.value = expression;
    }

    public boolean isQuery() {
        return true;
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean isReadOnly() {
        return this.value.isEverything(5);
    }
}

