% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varEVI.R
\name{varEVI}
\alias{varEVI}
\title{Calculate the enhanced vegetation index (EVI)}
\usage{
varEVI(blue, red, nir, scfun = function(r) {     r })
}
\arguments{
\item{blue}{a \code{raster} with the blue band of the capture.}

\item{red}{a \code{raster} with the red band of the capture.}

\item{nir}{a \code{raster} with the NIR band of the capture.}

\item{scfun}{a function to re-scale the original pixel values into 
reflectance (0-1).}
}
\value{
An EVI image in \code{raster} format.
}
\description{
\code{varEVI} computes the enhanced vegetation index (EVI) from the 
blue, near-infrared (NIR) and red bands.
}
\details{
The enhanced vegetation index (EVI) is a vegetation indicator that improves
sensitivity towards high biomass densities compared to NDVI 
\insertCite{huete2002overview}{RGISTools} (See \code{\link{varNDVI}}). This
function is used within \code{\link{ls7FolderToVar}},
\code{\link{ls8FolderToVar}}, \code{\link{modFolderToVar}} and
\code{\link{senFolderToVar}}.
}
\examples{
# path to the cropped and cutted MODIS images for the region of Navarre
img.dir <- system.file("ExNavarreVar", package = "RGISTools")
# list all the tif files
img.files <- list.files(img.dir, pattern = "\\\\.tif$", recursive = TRUE, full.names = TRUE)
# print the MOD09 bands
getRGISToolsOpt("MOD09BANDS")
scale.factor <- 0.0001

# select the red, blue and nir bands
red <- raster(img.files[1]) * scale.factor
blue <- raster(img.files[3]) * scale.factor
nir <- raster(img.files[2]) * scale.factor
# calculate the EVI without scale
evi.1 <- varEVI(blue, red, nir)
# calculate the EVI scaling 0-1
evi.2 <- varEVI(blue, red, nir,scfun=getRGISToolsOpt("MOD09SCL"))
evi.12 <- stack(evi.1,evi.2)
# plot the image
spplot(evi.12,col.regions=rev(terrain.colors(20)),at = c(seq(0,1,0.05)))
}
\references{
\insertRef{huete2002overview}{RGISTools}
}
