% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modCloudMask.R
\name{modCloudMask}
\alias{modCloudMask}
\title{Create cloud masks for MODIS images}
\usage{
modCloudMask(startDate, endDate, AppRoot, extent, out.name = "outname",
  raw.rm = FALSE, overwrite = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{startDate}{a \code{Date} class object with the starting date of the 
study period.}

\item{endDate}{a \code{Date} class object with the ending date of the 
study period.}

\item{AppRoot}{the directory where cloud masks are saved.}

\item{extent}{An \code{extent}, \code{Raster*}, or \code{Spatial*} object
representing the region of interest with longitude/latitude coordinates.}

\item{out.name}{he name of the folder that stores the outputs. By default,
“outfile” is assigned.}

\item{raw.rm}{logical argument. If \code{TRUE}, raw images are removed.}

\item{overwrite}{logical argument. If \code{TRUE}, overwrites the existing
images with the same name.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the 
running steps and warnings.}

\item{...}{arguments for nested functions.}
}
\description{
\code{modCloudMask} creates cloud masks derived from the "\code{MOD35_L2}" 
product.
}
\details{
This function, downloads and processes the "\code{MOD35_L2}" products to create
cloud masks composed of \code{NA}'s (cloud) and \code{1}'s (clear). The
resulting cloud mask layers need to be reprojected because resolution and
projection differences with other MODIS products. This function requires
`GDAL' and the `\code{gdalUtils}' library properly installed.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
src <- paste0(tempdir(),"/Path_for_downloading_folder")
print(src)

# search and download images from MODIS between
# 01-01-2018 and 03-01-2018 for the region of Navarre
modDownload(product = "MOD09GA",
            startDate = as.Date("01-01-2018", "\%d-\%m-\%Y"),
            endDate = as.Date("03-01-2018", "\%d-\%m-\%Y"),
            username = "username",
            password = "password",
            AppRoot = src,
            extract.tif = TRUE,
            collection = 6,
            extent = ex.navarre)
            
# assign src1 as the output folder for modMosaic
src.mod <- file.path(src, "Modis")
src.tiles <- file.path(src.mod, "MOD09GA")
tif.src.tiles <- file.path(src.tiles, "tif")
# mosaic the MODIS images
modMosaic(tif.src.tiles, # the input folder 
          AppRoot = src.tiles, # the output folder 
          out.name = "Navarre", # creates Navarre folder in AppRoot
          gutils = TRUE,
          extent = ex.navarre)
          
# generate the cloud masks      
modCloudMask(startDate = as.Date("01-01-2018", "\%d-\%m-\%Y"),
             endDate = as.Date("04-01-2018", "\%d-\%m-\%Y"),
             extent = ex.navarre,
             AppRoot = src,
             out.name = "Navarre")
             
src.cloud <- file.path(src.mod,"CloudMask")
# the cloud mask may have different extent, resolution...  
src.cloud.navarre <- file.path(src.cloud,"Navarre")
cmask <- list.files(src.cloud.navarre, full.names = TRUE, pattern = "\\\\.tif$")
cmask.ras <- lapply(cmask, raster)

navarre.path <- file.path(src.tiles, "Navarre")
navarre.img <- list.files(navarre.path,
                          full.names = TRUE,
                          recursive = TRUE,
                          pattern = "\\\\.tif$")
# select b01
navarre.img <- navarre.img[grepl("b01_1",navarre.img)]
navarre.b01.ras <- lapply(navarre.img,raster)
navarre.b01.stack <- stack(lapply(navarre.b01.ras, projectRaster, navarre.b01.ras[[1]]))

# reproject the cloud mask to the projection of navarre.b01.stack
cmask.stack <- stack(lapply(cmask.ras, projectRaster, navarre.b01.stack))

# plot the cloud free b01 layer
spplot(navarre.b01.stack*cmask.stack)
}
}
