% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_input.R
\name{amecoData2input}
\alias{amecoData2input}
\title{Data for estimation}
\usage{
amecoData2input(tslAmeco, alpha = 0.65)
}
\arguments{
\item{tslAmeco}{A time series list or a multiple time series object containing AMECO
data.}

\item{alpha}{A number between \code{0} and \code{1} indicating the labor share. The
default is \code{alpha = 0.65}.}
}
\value{
A list of time series containing the same components as the input list \code{tslAmeco}
   and the following additional components:
  \item{gdpdefl}{Gross domestic product deflator}
  \item{tfp}{Total factor productivity}
  \item{lfnd}{Labor force non-domestic (unit: 1000 persons)}
  \item{parts}{Participation rate}
  \item{ahours}{Average hours worked (unit: hours)}
  \item{prod}{Labor productivity (unit: real output in millions per person)}
  \item{tot}{Terms of trade (pconcp / gdpdefl)}
  \item{ws}{Wage share (unit: compensation per unit of nominal output)}
  \item{winfl}{Wage inflation}
  \item{rulc}{Real unit labor costs}
}
\description{
Computes the necessary input data for the EC output gap estimation on the basis of AMECO
data.
}
\details{
The list of time series \code{tslAmeco} needs to have the following components:
\describe{
  \item{popw}{Population: 15 to 64 years (unit: 1000 persons, code: NPAN)}
  \item{ur}{Unemployment rate, total; Member States: definition EUROSTAT (unit: Percentage of civilian labor force, code: ZUTN)}
  \item{etd}{Employment, persons: total economy (National accounts) (unit: 1000 persons, code: NETN)}
  \item{et}{Employment, persons: all domestic industries (National accounts) (unit: 1000 persons, code: NETD)}
  \item{eet}{Employees, persons: all domestic industries (National accounts) (unit: 1000 persons, code: NWTD)}
  \item{pconsp}{Price deflator private final consumption expenditure (unit: National currency reference year = 100, code: PCPH)}
  \item{ngdp}{Gross domestic product at current prices (unit: bn National currency, code: UVGD)}
  \item{gdp}{Gross domestic product at constant prices (unit: bn National currency, code: OVGD)}
  \item{l}{Total annual hours worked: total economy (unit: millions, code: NLHT)}
  \item{wtotal}{Compensation of employees: total economy (unit: bn National currency, code: UWCD)}
  \item{nulc}{Nominal unit labour costs: total economy (Ratio of compensation per employee to real GDP per person employed.) (unit: National currency reference year = 100, code: PLCD)}
  \item{k}{Net capital stock at constant prices: total economy (unit: bn National currency, code: OKND)}
}
}
\examples{
# load data for Germany
data("gap")
country <- "Germany"
tsListRaw <- gap[[country]]
tsListInput <- amecoData2input(tslAmeco = tsListRaw)
}
