/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer;

import freak.core.control.Schedule;
import freak.core.event.IndividualListEvent;
import freak.core.event.IndividualListEventListener;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.AbstractObserver;
import freak.core.population.Individual;
import freak.core.population.IndividualList;

public class AverageFitness
extends AbstractObserver
implements IndividualListEventListener,
Configurable {
    public AverageFitness(Schedule schedule) {
        super(schedule);
        this.setMeasure(1);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This module works on single objective fitness functions only.");
        }
    }

    public String getName() {
        return "Average Fitness";
    }

    public String getDescription() {
        return "Computes the individuals' average fitness.";
    }

    public Class getOutputDataType() {
        return Double.class;
    }

    public void individualList(IndividualListEvent evt) {
        IndividualList individualList = evt.getIndividualList();
        Individual[] individuals = individualList.toArray();
        SingleObjectiveFitnessFunction fitness = (SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction();
        double sum = 0.0;
        int i = 0;
        while (i < individuals.length) {
            sum += fitness.evaluate(individuals[i], individualList);
            ++i;
        }
        double average = sum / (double)individuals.length;
        this.updateViews(new Double(average));
    }

    public void createEvents() {
        super.createEvents();
        this.getSchedule().getEventController().addEvent(this, "Get individuals from", IndividualListEvent.class, this.getSchedule().getPopulationManager());
    }
}

