/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.graphedgeselection;

import edu.ucsb.cs.jicos.applications.utilities.graph.WeightedMatch;
import freak.core.control.Schedule;
import freak.core.event.BatchEvent;
import freak.core.event.BatchEventListener;
import freak.core.event.EventListener;
import freak.core.event.RunEvent;
import freak.core.event.RunEventListener;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.module.searchspace.GraphEdgeSelection;
import freak.module.searchspace.GraphEdgeSelectionGenotype;

public class MaximumMatchings
extends AbstractStaticSingleObjectiveFitnessFunction
implements BatchEventListener,
RunEventListener {
    private GraphEdgeSelectionGenotype optimum;
    int[] maxMatchingCache;
    boolean firstTime = true;
    int number = 0;
    int lowerBound = 0;

    public MaximumMatchings(Schedule schedule) {
        super(schedule);
    }

    public double evaluate(Genotype genotype) {
        GraphEdgeSelectionGenotype edgeSelectionGenotype = (GraphEdgeSelectionGenotype)genotype;
        GraphEdgeSelection.Graph graph = edgeSelectionGenotype.getGraph();
        int nodes = graph.getNumberOfNodes();
        int edges = graph.getNumberOfEdges();
        int[] nodesCoveredCount = new int[nodes];
        boolean[] edgeSelection = edgeSelectionGenotype.getEdgeSelection();
        int edgeCount = 0;
        int penalty = 0;
        int i = 0;
        while (i < edges) {
            if (edgeSelection[i]) {
                ++edgeCount;
                GraphEdgeSelection.Graph.Edge edge = graph.edgeForSpeedupIndex(i);
                int n1 = edge.getEndNode();
                int n2 = edge.getStartNode();
                int n = n1;
                nodesCoveredCount[n] = nodesCoveredCount[n] + 1;
                int n3 = n2;
                nodesCoveredCount[n3] = nodesCoveredCount[n3] + 1;
            }
            ++i;
        }
        i = 0;
        while (i < nodes) {
            int count = nodesCoveredCount[i];
            if (count > 1) {
                penalty += count * (count - 1) / 2;
            }
            ++i;
        }
        if (this.lowerBound > -penalty) {
            this.lowerBound = -penalty;
        }
        if (penalty > 0) {
            return -penalty;
        }
        return edgeCount;
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        if (this.firstTime) {
            GraphEdgeSelection.Graph graph = ((GraphEdgeSelection)this.schedule.getPhenotypeSearchSpace()).getGraph();
            if (graph == null) {
                return 0.0;
            }
            int nodes = graph.getNumberOfNodes();
            int[][] costs = new int[nodes][nodes];
            int i = 0;
            while (i < nodes) {
                costs[i][i] = 0;
                int j = i + 1;
                while (j < nodes) {
                    int edgeNr = graph.findEdgeSelectionIndexForEdge(i, j);
                    costs[i][j] = edgeNr != -1 ? 1 : 0;
                    costs[j][i] = costs[i][j];
                    ++j;
                }
                ++i;
            }
            this.maxMatchingCache = new WeightedMatch(costs).weightedMatch(false);
            this.number = 0;
            i = 1;
            while (i < this.maxMatchingCache.length - 1) {
                if (this.maxMatchingCache[i] != 0) {
                    ++this.number;
                }
                ++i;
            }
            this.number /= 2;
            this.firstTime = false;
        }
        return this.number;
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return this.lowerBound;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        GraphEdgeSelection.Graph graph;
        if (this.optimum == null && (graph = ((GraphEdgeSelection)this.schedule.getPhenotypeSearchSpace()).getGraph()) != null) {
            this.getOptimalFitnessValue();
            if (!this.firstTime) {
                this.optimum = new GraphEdgeSelectionGenotype(graph);
                boolean[] edgeSelection = this.optimum.getEdgeSelection();
                int i = 1;
                while (i < this.maxMatchingCache.length - 1) {
                    int j = this.maxMatchingCache[i];
                    if (j != 0) {
                        int edgeIndex = graph.findEdgeSelectionIndexForEdge(i - 1, j - 1);
                        edgeSelection[edgeIndex] = true;
                    }
                    ++i;
                }
                this.optimum.setEdgeSelection(edgeSelection);
            }
        }
        return this.optimum;
    }

    public String getDescription() {
        return "(none)";
    }

    public String getName() {
        return "Maximum Matchings";
    }

    public void batchStarted(BatchEvent evt) {
        this.firstTime = true;
        this.lowerBound = 0;
    }

    public void runStarted(RunEvent evt) {
        this.firstTime = true;
        this.optimum = null;
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, BatchEvent.class, this.schedule);
        this.schedule.getEventController().addEvent((EventListener)this, RunEvent.class, this.schedule);
    }
}

