/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.scheduleeditor;

import freak.core.graph.Initialization;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Module;
import freak.core.populationmanager.PopulationManager;
import freak.gui.ModuleList;
import freak.gui.scheduleeditor.ScheduleEditor;
import freak.gui.scheduleeditor.ScheduleEditorPanel;
import freak.gui.scheduleeditor.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PanelPopulation
extends ScheduleEditorPanel {
    private Module[] populationManagers;
    private Module[] initializationOperators;
    private JButton buConfigInitializationOperator;
    private JButton buConfigPopulationManager;
    private JLabel jLabel16;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel33;
    private JLabel jLabel34;
    private JPanel jPanel1;
    private JPanel jPanel11;
    private JPanel jPanel5;
    private JScrollPane jScrollPane10;
    private JScrollPane jScrollPane13;
    private JScrollPane jScrollPane14;
    private JScrollPane jScrollPane9;
    private JList listInitializationOperators;
    private JList listPopulationManager;
    private JTextArea taDescrInitializationOperator;
    private JTextArea taDescrPopulationManager;
    private JTextField tfOptionsInitializationOperator;
    private JTextField tfOptionsPopulationManager;

    public PanelPopulation(ScheduleEditor scheduleEditor) {
        super(scheduleEditor);
        this.initComponents();
    }

    public static String getDescription() {
        return "Setup Initial Population";
    }

    public String getHelpURL() {
        return "node4.html#SECTION00446000000000000000";
    }

    protected void initForStartedSchedule() {
        this.listPopulationManager.setEnabled(false);
        this.listInitializationOperators.setEnabled(false);
        this.buConfigPopulationManager.setVisible(false);
        this.buConfigInitializationOperator.setVisible(false);
    }

    public boolean mayAdvance() {
        return this.schedule.getPopulationManager() != null && this.schedule.getInitialization() != null;
    }

    public void enter() {
        super.enter();
        this.populationManagers = this.moduleCollector.getPopulationManagers();
        ((ModuleList)this.listPopulationManager).setModules(this.populationManagers, this.schedule.getPopulationManager());
        this.initializationOperators = this.moduleCollector.getInitializationOperators();
        ((ModuleList)this.listInitializationOperators).setModules(this.initializationOperators, this.schedule.getInitialization());
    }

    private void parsePopulationManager() {
        PopulationManager m = this.schedule.getPopulationManager();
        Util.displayText(this.taDescrPopulationManager, m.getDescription());
        if (m instanceof Configurable) {
            Util.displayText(this.tfOptionsPopulationManager, ((Configurable)((Object)m)).getConfiguration().getDescription());
        } else {
            Util.displayText(this.tfOptionsPopulationManager, "<not configurable>");
        }
        this.buConfigPopulationManager.setEnabled(m instanceof Configurable);
    }

    private void parseInitializationOperator() {
        Initialization m = this.schedule.getInitialization();
        Util.displayText(this.taDescrInitializationOperator, m.getDescription());
        if (m instanceof Configurable) {
            Util.displayText(this.tfOptionsInitializationOperator, ((Configurable)m).getConfiguration().getDescription());
        } else {
            Util.displayText(this.tfOptionsInitializationOperator, "<not configurable>");
        }
        this.buConfigInitializationOperator.setEnabled(m instanceof Configurable);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jScrollPane9 = new JScrollPane();
        this.listPopulationManager = new ModuleList();
        this.jScrollPane10 = new JScrollPane();
        this.taDescrPopulationManager = new JTextArea();
        this.jLabel22 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jLabel24 = new JLabel();
        this.tfOptionsPopulationManager = new JTextField();
        this.buConfigPopulationManager = new JButton();
        this.jPanel11 = new JPanel();
        this.jScrollPane13 = new JScrollPane();
        this.listInitializationOperators = new ModuleList();
        this.jScrollPane14 = new JScrollPane();
        this.taDescrInitializationOperator = new JTextArea();
        this.jLabel33 = new JLabel();
        this.jLabel34 = new JLabel();
        this.jLabel16 = new JLabel();
        this.tfOptionsInitializationOperator = new JTextField();
        this.buConfigInitializationOperator = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Select Population Model & Initialization"));
        this.jPanel1.setLayout(new GridLayout(2, 1));
        this.jPanel5.setLayout(new GridBagLayout());
        this.jScrollPane9.setMinimumSize(new Dimension(220, 0));
        this.jScrollPane9.setPreferredSize(new Dimension(220, 0));
        this.listPopulationManager.setSelectionMode(0);
        this.listPopulationManager.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                PanelPopulation.this.listPopulationManagerValueChanged(evt);
            }
        });
        this.jScrollPane9.setViewportView(this.listPopulationManager);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel5.add((Component)this.jScrollPane9, gridBagConstraints);
        this.taDescrPopulationManager.setEditable(false);
        this.taDescrPopulationManager.setLineWrap(true);
        this.taDescrPopulationManager.setText("<no population model selected>");
        this.taDescrPopulationManager.setWrapStyleWord(true);
        this.jScrollPane10.setViewportView(this.taDescrPopulationManager);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel5.add((Component)this.jScrollPane10, gridBagConstraints);
        this.jLabel22.setText("Population Models:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel5.add((Component)this.jLabel22, gridBagConstraints);
        this.jLabel23.setText("Description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel5.add((Component)this.jLabel23, gridBagConstraints);
        this.jLabel24.setText("Options:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel5.add((Component)this.jLabel24, gridBagConstraints);
        this.tfOptionsPopulationManager.setEditable(false);
        this.tfOptionsPopulationManager.setText("<no population model selected>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.jPanel5.add((Component)this.tfOptionsPopulationManager, gridBagConstraints);
        this.buConfigPopulationManager.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        this.buConfigPopulationManager.setMnemonic('o');
        this.buConfigPopulationManager.setText("Configure...");
        this.buConfigPopulationManager.setEnabled(false);
        this.buConfigPopulationManager.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelPopulation.this.buConfigPopulationManagerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel5.add((Component)this.buConfigPopulationManager, gridBagConstraints);
        this.jPanel1.add(this.jPanel5);
        this.jPanel11.setLayout(new GridBagLayout());
        this.jScrollPane13.setMinimumSize(new Dimension(220, 0));
        this.jScrollPane13.setPreferredSize(new Dimension(220, 0));
        this.listInitializationOperators.setSelectionMode(0);
        this.listInitializationOperators.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                PanelPopulation.this.listInitializationOperatorsValueChanged(evt);
            }
        });
        this.jScrollPane13.setViewportView(this.listInitializationOperators);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel11.add((Component)this.jScrollPane13, gridBagConstraints);
        this.taDescrInitializationOperator.setEditable(false);
        this.taDescrInitializationOperator.setLineWrap(true);
        this.taDescrInitializationOperator.setText("<no initialization operator selected>");
        this.taDescrInitializationOperator.setWrapStyleWord(true);
        this.jScrollPane14.setViewportView(this.taDescrInitializationOperator);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel11.add((Component)this.jScrollPane14, gridBagConstraints);
        this.jLabel33.setText("Initialization Modules:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel11.add((Component)this.jLabel33, gridBagConstraints);
        this.jLabel34.setText("Description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel11.add((Component)this.jLabel34, gridBagConstraints);
        this.jLabel16.setText("Options:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel11.add((Component)this.jLabel16, gridBagConstraints);
        this.tfOptionsInitializationOperator.setEditable(false);
        this.tfOptionsInitializationOperator.setText("<no initialization operator selected>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.jPanel11.add((Component)this.tfOptionsInitializationOperator, gridBagConstraints);
        this.buConfigInitializationOperator.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        this.buConfigInitializationOperator.setMnemonic('o');
        this.buConfigInitializationOperator.setText("Configure...");
        this.buConfigInitializationOperator.setEnabled(false);
        this.buConfigInitializationOperator.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelPopulation.this.buConfigInitializationOperatorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel11.add((Component)this.buConfigInitializationOperator, gridBagConstraints);
        this.jPanel1.add(this.jPanel11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void buConfigInitializationOperatorActionPerformed(ActionEvent evt) {
        String s = Util.configureModule(this.scheduleEditor, this.schedule.getInitialization(), this.schedule);
        if (s != null) {
            Util.displayText(this.tfOptionsInitializationOperator, s);
        }
        this.scheduleDependencyChecker.processNewModuleConfiguration(this.schedule.getInitialization());
        this.scheduleEditor.updateComponents();
    }

    private void buConfigPopulationManagerActionPerformed(ActionEvent evt) {
        String s = Util.configureModule(this.scheduleEditor, this.schedule.getPopulationManager(), this.schedule);
        if (s != null) {
            Util.displayText(this.tfOptionsPopulationManager, s);
        }
        this.scheduleDependencyChecker.processNewModuleConfiguration(this.schedule.getPopulationManager());
        this.scheduleEditor.updateComponents();
    }

    private void listInitializationOperatorsValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        Initialization oldObj = this.schedule.getInitialization();
        Initialization newObj = (Initialization)this.listInitializationOperators.getSelectedValue();
        if (newObj != oldObj) {
            if (oldObj != null) {
                this.eventController.replaceGlobalEventSource(oldObj, newObj);
                this.eventController.removeModule(oldObj);
            }
            this.schedule.setInitialization(newObj);
            this.scheduleDependencyChecker.processNewInitializationOperator();
            newObj.createEvents();
            this.scheduleEditor.updateComponents();
        }
        this.parseInitializationOperator();
    }

    private void listPopulationManagerValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        PopulationManager oldObj = this.schedule.getPopulationManager();
        PopulationManager newObj = (PopulationManager)this.listPopulationManager.getSelectedValue();
        if (newObj != oldObj) {
            if (oldObj != null) {
                this.eventController.replaceGlobalEventSource(oldObj, newObj);
                this.eventController.removeModule(oldObj);
            }
            this.schedule.setPopulationManager(newObj);
            this.scheduleDependencyChecker.processNewPopulationManager();
            newObj.createEvents();
            this.scheduleEditor.updateComponents();
        }
        this.parsePopulationManager();
    }
}

