/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.graph;

import freak.core.control.Schedule;
import freak.core.graph.Operator;
import freak.core.modulesupport.Module;
import freak.core.modulesupport.ModuleCollector;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.modulesupport.inspector.InspectorVetoException;
import freak.core.parametercontroller.ParameterController;
import freak.gui.ConfigurationPanel;
import freak.gui.JButtonFactory;
import freak.gui.ModuleList;
import freak.gui.graph.PropertyChooser;
import freak.gui.scheduleeditor.Util;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class ParameterControllerDialog
extends JDialog {
    private Schedule schedule;
    private List parameterController;
    private Module[] parameterControllers;
    private ModuleCollector moduleCollector;
    private ConfigurationPanel displayedConfigurationPanel;
    private JButton buAdd;
    private JButton buChoose;
    private JButton buClose;
    private JButton buRemove;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSplitPane jSplitPane1;
    private JList listActivePCs;
    private JList listParameterController;
    private JTable tableProperties;

    public ParameterControllerDialog(Dialog parent, Schedule schedule) {
        super(parent, true);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.schedule = schedule;
        if (schedule.getOperatorGraph().getParameterControllers() == null) {
            throw new NullPointerException("ParameterControllerPanel needs a list of parameter controllers.");
        }
        this.moduleCollector = new ModuleCollector(schedule);
        this.setup();
    }

    private void setup() {
        this.jSplitPane1.setRightComponent(null);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane1.setDividerLocation(-1);
        DefaultTableModel tm = new DefaultTableModel(null, new Object[]{"Parameter", "Operator", "Property"}){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tableProperties.setModel(tm);
        this.tableProperties.setSelectionMode(0);
        ListSelectionModel sm = this.tableProperties.getSelectionModel();
        sm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ParameterControllerDialog.this.tablePropertiesValueChanged(e);
            }
        });
        this.parameterControllers = this.moduleCollector.getParameterControllers();
        ((ModuleList)this.listParameterController).setModules(this.parameterControllers, null);
        this.parameterController = this.schedule.getOperatorGraph().getParameterControllers();
        DefaultListModel lm = Util.createListModelFrom(this.parameterController);
        this.listActivePCs.setModel(lm);
        this.displayInspector(null);
    }

    private void displayInspector(Module m) {
        try {
            if (this.displayedConfigurationPanel != null) {
                this.displayedConfigurationPanel.finishEditing();
            }
        }
        catch (InspectorVetoException ex) {
            String message = "The properties of module " + this.displayedConfigurationPanel.getConfiguredModule().getName() + " are invalid.\n" + ex.getMessage();
            JOptionPane.showMessageDialog(this, message, "Invalid Property Settings", 0);
            return;
        }
        JPanel inspector = null;
        inspector = m != null ? new ConfigurationPanel(m, this.schedule.getEventController(), this.schedule.getPossibleEventSources(), this.schedule.getBatchList()) : new JPanel();
        inspector.setPreferredSize(new Dimension(200, 0));
        inspector.setMinimumSize(new Dimension(200, 20));
        this.displayedConfigurationPanel = inspector instanceof ConfigurationPanel ? (ConfigurationPanel)inspector : null;
        this.jSplitPane1.setRightComponent(inspector);
        this.jSplitPane1.setDividerLocation(-1);
    }

    private void updateParameterTable(ParameterController pc) {
        DefaultTableModel tm = (DefaultTableModel)this.tableProperties.getModel();
        tm.setNumRows(0);
        if (pc != null) {
            String[] parameters = pc.getListOfParameters();
            int i = 0;
            while (i < parameters.length) {
                String propName;
                String gateName = "<none yet>";
                Operator source = pc.getOperatorForParameter(parameters[i]);
                if (source != null) {
                    gateName = source.getPropertyName();
                }
                if ((propName = pc.getPropDescriptionForParameter(parameters[i])) == null) {
                    propName = "<none yet>";
                }
                Object[] data = new Object[]{parameters[i], gateName, propName};
                tm.addRow(data);
                ++i;
            }
        }
    }

    private void tablePropertiesValueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        this.buChoose.setEnabled(!lsm.isSelectionEmpty());
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.listParameterController = new ModuleList();
        this.buAdd = JButtonFactory.newButton();
        this.jPanel1 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.listActivePCs = new JList();
        this.jScrollPane4 = new JScrollPane();
        this.tableProperties = new JTable();
        this.buRemove = JButtonFactory.newButton();
        this.buChoose = JButtonFactory.newButton();
        this.jPanel4 = new JPanel();
        this.buClose = JButtonFactory.newButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(0);
        this.setTitle("Parameter Controller Setup");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ParameterControllerDialog.this.closeDialog(evt);
            }
        });
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new TitledBorder("Available"));
        this.jScrollPane2.setMinimumSize(new Dimension(200, 0));
        this.jScrollPane2.setPreferredSize(new Dimension(200, 0));
        this.listParameterController.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ParameterControllerDialog.this.listParameterControllerValueChanged(evt);
            }
        });
        this.listParameterController.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ParameterControllerDialog.this.listParameterControllerMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.listParameterController);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel2.add((Component)this.jScrollPane2, gridBagConstraints);
        this.buAdd.setText("Add Parameter Controller");
        this.buAdd.setToolTipText("Add parameter controller to active setup.");
        this.buAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParameterControllerDialog.this.buAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.buAdd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        this.jPanel3.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder("Active"));
        this.listActivePCs.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ParameterControllerDialog.this.listActivePCsFocusGained(evt);
            }
        });
        this.listActivePCs.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ParameterControllerDialog.this.listActivePCsValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.listActivePCs);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.jPanel1.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jScrollPane4.setViewportView(this.tableProperties);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.jScrollPane4, gridBagConstraints);
        this.buRemove.setMnemonic('r');
        this.buRemove.setText("Remove");
        this.buRemove.setToolTipText("Remove selected parameter controller from active setup.");
        this.buRemove.setEnabled(false);
        this.buRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParameterControllerDialog.this.buRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel1.add((Component)this.buRemove, gridBagConstraints);
        this.buChoose.setMnemonic('c');
        this.buChoose.setText("Choose Property");
        this.buChoose.setToolTipText("Choose a property to control from an operator of the graph.");
        this.buChoose.setEnabled(false);
        this.buChoose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParameterControllerDialog.this.buChooseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.buChoose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.jPanel3.add((Component)this.jPanel1, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.jPanel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jSplitPane1, gridBagConstraints);
        this.buClose.setMnemonic('c');
        this.buClose.setText("Close");
        this.buClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParameterControllerDialog.this.buCloseActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.buClose);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.pack();
    }

    private void buCloseActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        try {
            if (this.displayedConfigurationPanel != null) {
                this.displayedConfigurationPanel.finishEditing();
            }
        }
        catch (InspectorVetoException ex) {
            String message = "The properties of module " + this.displayedConfigurationPanel.getConfiguredModule().getName() + " are invalid.\n" + ex.getMessage();
            JOptionPane.showMessageDialog(this, message, "Invalid Property Settings", 0);
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    private void listActivePCsFocusGained(FocusEvent evt) {
    }

    private void listParameterControllerMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.buAddActionPerformed(null);
        }
    }

    private void listActivePCsValueChanged(ListSelectionEvent evt) {
        if (!this.listActivePCs.isSelectionEmpty()) {
            ParameterController pc = (ParameterController)this.parameterController.get(this.listActivePCs.getSelectedIndex());
            this.updateParameterTable(pc);
            this.buRemove.setEnabled(true);
            this.displayInspector(pc);
        } else {
            this.updateParameterTable(null);
            this.buRemove.setEnabled(false);
            this.displayInspector(null);
        }
    }

    private void buChooseActionPerformed(ActionEvent evt) {
        if (!this.listActivePCs.isSelectionEmpty() && !this.tableProperties.getSelectionModel().isSelectionEmpty()) {
            ParameterController pc = (ParameterController)this.parameterController.get(this.listActivePCs.getSelectedIndex());
            String paramName = (String)this.tableProperties.getModel().getValueAt(this.tableProperties.getSelectedRow(), 0);
            Class paramType = pc.getParameterType(paramName);
            PropertyChooser d = new PropertyChooser((Dialog)this, pc, paramType, this.schedule.getOperatorGraph());
            d.setVisible(true);
            Operator g = d.getOperator();
            if (g != null) {
                String propName = d.getPropertyName();
                pc.setPropertyForParameter(paramName, g, propName);
                this.updateParameterTable(pc);
            }
        }
    }

    private void buRemoveActionPerformed(ActionEvent evt) {
        if (!this.listActivePCs.isSelectionEmpty()) {
            int index = this.listActivePCs.getSelectedIndex();
            ParameterController pc = (ParameterController)this.parameterController.get(index);
            this.schedule.getEventController().removeModule(pc);
            this.parameterController.remove(pc);
            DefaultListModel lm = (DefaultListModel)this.listActivePCs.getModel();
            lm.removeElementAt(index);
        }
    }

    private void listParameterControllerValueChanged(ListSelectionEvent evt) {
        if (!this.listParameterController.isSelectionEmpty()) {
            this.buAdd.setEnabled(true);
        } else {
            this.buAdd.setEnabled(false);
        }
    }

    private void buAddActionPerformed(ActionEvent evt) {
        if (!this.listParameterController.isSelectionEmpty()) {
            ParameterController selectedController = (ParameterController)this.listParameterController.getSelectedValue();
            ParameterController pc = null;
            try {
                pc = (ParameterController)this.moduleCollector.newModule(selectedController.getClass(), new Object[]{this.schedule.getOperatorGraph()});
            }
            catch (UnsupportedEnvironmentException e) {
                throw new RuntimeException("Parameter Controller " + selectedController.getClass() + " not supported even though checked before.");
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Parameter Controller " + selectedController.getClass() + " could not be instantiated even though checked before.");
            }
            pc.createEvents();
            this.parameterController.add(pc);
            DefaultListModel lm = (DefaultListModel)this.listActivePCs.getModel();
            lm.addElement(pc.getName());
            this.listActivePCs.setSelectedIndex(lm.getSize() - 1);
            this.listActivePCs.ensureIndexIsVisible(this.listActivePCs.getSelectedIndex());
        }
    }
}

