% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cop_Discrete.R
\name{copulaDiscrete}
\alias{copulaDiscrete}
\title{Fitting Linear Models with Endogeneous Discrete Regressors using Internal Instrumental Variables}
\usage{
copulaDiscrete(y, X, P, intercept = NULL, data = NULL)
}
\arguments{
\item{y}{the vector containing the dependent variable.}

\item{X}{the matrix containing the regressors, with the endogenous variables occupying the last columns.}

\item{P}{the matrix containing the discrete endogeneous regressors.}

\item{intercept}{the intercept of the model. It should be specified whether the model should be estimated with or without intercept. 
If no intercept is desired, intercept should be given the value "FALSE", otherwise the value "TRUE".}

\item{data}{the matrix or data frame containing the dataset used.}
}
\value{
Returns an object of class "lm".
}
\description{
Fits linear models with discrete, endogeneous regressors using the approach described in Park and Gupta (2012). Due to the variablility 
in pStar, a simulation was needed in order to obtain the coefficient estimates. Then, in order to get the Z-scores and p-values the sum of the Z method was used
as described in  Zaykin, D V.(2011). "Optimally weighted Z-test is a powerful method for combining probabilities in meta-analysis". Journal of Evolutionary Biology, 24:1836-1841.
}
\references{
Park, S. and Gupta, S., (2012), 'Handling Endogeneous Regressors by Joint Estimation Using Copulas', Marketing Science, 31(4), 567-86.
}
\keyword{internal}

