/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.BetaSymmetricalDist;
import umontreal.iro.lecuyer.randvar.BetaSymmetricalGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class BetaSymmetricalPolarGen
extends BetaSymmetricalGen {
    private double afactor;
    private RandomStream stream2;

    public BetaSymmetricalPolarGen(RandomStream randomStream, RandomStream randomStream2, BetaSymmetricalDist betaSymmetricalDist) {
        super(randomStream, betaSymmetricalDist);
        this.stream2 = randomStream2;
        if (betaSymmetricalDist.getAlpha() <= 0.5) {
            throw new IllegalArgumentException("  must have alpha > 1/2");
        }
        this.afactor = 2.0 / (2.0 * betaSymmetricalDist.getAlpha() - 1.0);
    }

    public BetaSymmetricalPolarGen(RandomStream randomStream, BetaSymmetricalDist betaSymmetricalDist) {
        this(randomStream, randomStream, betaSymmetricalDist);
    }

    public static double nextDouble(RandomStream randomStream, RandomStream randomStream2, double d) {
        double d2;
        double d3;
        double d4;
        while ((d4 = (d3 = randomStream.nextDouble()) * d3 + (d2 = -1.0 + 2.0 * randomStream2.nextDouble()) * d2) > 1.0) {
        }
        return 0.5 + d3 * d2 / d4 * Math.sqrt(1.0 - Math.pow(d4, 2.0 / (2.0 * d - 1.0)));
    }

    public static double nextDouble(RandomStream randomStream, double d) {
        return BetaSymmetricalPolarGen.nextDouble(randomStream, randomStream, d);
    }

    public double nextDouble() {
        double d;
        double d2;
        double d3;
        while ((d3 = (d2 = this.stream.nextDouble()) * d2 + (d = -1.0 + 2.0 * this.stream2.nextDouble()) * d) > 1.0) {
        }
        return 0.5 + d2 * d / d3 * Math.sqrt(1.0 - Math.pow(d3, this.afactor));
    }

    public RandomStream getStream2() {
        return this.stream2;
    }
}

