/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import optimization.Uncmin_f77;
import optimization.Uncmin_methods;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.EmpiricalDist;
import umontreal.iro.lecuyer.util.Misc;

public class CauchyDist
extends ContinuousDistribution {
    private double alpha;
    private double beta;

    public CauchyDist() {
        this.setParams(0.0, 1.0);
    }

    public CauchyDist(double d, double d2) {
        this.setParams(d, d2);
    }

    public double density(double d) {
        return CauchyDist.density(this.alpha, this.beta, d);
    }

    public double cdf(double d) {
        return CauchyDist.cdf(this.alpha, this.beta, d);
    }

    public double barF(double d) {
        return CauchyDist.barF(this.alpha, this.beta, d);
    }

    public double inverseF(double d) {
        return CauchyDist.inverseF(this.alpha, this.beta, d);
    }

    public double getMean() {
        return CauchyDist.getMean(this.alpha, this.beta);
    }

    public double getVariance() {
        return CauchyDist.getVariance(this.alpha, this.beta);
    }

    public double getStandardDeviation() {
        return CauchyDist.getStandardDeviation(this.alpha, this.beta);
    }

    public static double density(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        double d4 = (d3 - d) / d2;
        return 1.0 / (d2 * Math.PI * (1.0 + d4 * d4));
    }

    public static double cdf(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return Math.atan((d3 - d) / d2) / Math.PI + 0.5;
    }

    public static double barF(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return 0.5 - Math.atan((d3 - d) / d2) / Math.PI;
    }

    public static double inverseF(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("u must be in [0,1]");
        }
        if (d3 <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d3 >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return d + Math.tan(Math.PI * (d3 - 0.5)) * d2;
    }

    public static double[] getMLE(double[] dArray, int n) {
        double d = 0.0;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        Optim optim = new Optim(dArray, n);
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        int[] nArray = new int[2];
        double[][] dArray7 = new double[3][3];
        double[] dArray8 = new double[3];
        dArray4[1] = EmpiricalDist.getMedian(dArray, n);
        int n2 = Math.round((float)n / 4.0f);
        double d2 = Misc.quickSelect(dArray, n, 3 * n2);
        double d3 = Misc.quickSelect(dArray, n, n2);
        dArray4[2] = (d2 - d3) / 2.0;
        Uncmin_f77.optif0_f77((int)2, (double[])dArray4, (Uncmin_methods)optim, (double[])dArray3, (double[])dArray5, (double[])dArray6, (int[])nArray, (double[][])dArray7, (double[])dArray8);
        for (int i = 0; i < 2; ++i) {
            dArray2[i] = dArray3[i + 1];
        }
        return dArray2;
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        return CauchyDist.getMLE(dArray, n);
    }

    public static CauchyDist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = CauchyDist.getMaximumLikelihoodEstimate(dArray, n);
        return new CauchyDist(dArray2[0], dArray2[1]);
    }

    public static double getMean(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        throw new UnsupportedOperationException("Undefined mean");
    }

    public static double getVariance(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double getStandardDeviation(double d, double d2) {
        return Double.POSITIVE_INFINITY;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setParams(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        this.alpha = d;
        this.beta = d2;
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.alpha, this.beta};
        return dArray;
    }

    public String toString() {
        return this.getClass().getName() + " : alpha = " + this.alpha + ", beta = " + this.beta;
    }

    private static class Optim
    implements Uncmin_methods {
        private int n;
        private double[] xi;

        public Optim(double[] dArray, int n) {
            this.n = n;
            this.xi = new double[n];
            System.arraycopy(dArray, 0, this.xi, 0, n);
        }

        public double f_to_minimize(double[] dArray) {
            double d = 0.0;
            if (dArray[2] <= 0.0) {
                return 1.0E200;
            }
            for (int i = 0; i < this.n; ++i) {
                d -= Math.log(CauchyDist.density(dArray[1], dArray[2], this.xi[i]));
            }
            return d;
        }

        public void gradient(double[] dArray, double[] dArray2) {
        }

        public void hessian(double[] dArray, double[][] dArray2) {
        }
    }
}

