/*
 * Decompiled with CFR 0.152.
 */
package javalain.ea;

public abstract class Evolution
implements Runnable {
    public static final int EXECUTABLE = 0;
    public static final int DEMARRE = 1;
    public static final int CONTINUE = 2;
    public static final int PAUSE = 3;
    public static final int TERMINE = 4;
    private boolean vivant;
    private int etatCrt;
    private int etatPrec;
    private int quiStop;
    private long tpsTotal;

    public Evolution() {
        Thread th = new Thread(this);
        this.vivant = true;
        this.etatCrt = 0;
        this.etatPrec = -1;
        th.setPriority(1);
        th.start();
    }

    public synchronized void setEtat(int e) {
        if (e == 0 || e == 1 || e == 2 || e == 3 || e == 4) {
            this.etatPrec = this.etatCrt;
            this.etatCrt = e;
            if (e == 4) {
                this.quiStop = 0;
            }
        }
    }

    public synchronized int getEtat() {
        return this.etatCrt;
    }

    public synchronized int getEtatPrecedent() {
        return this.etatPrec;
    }

    public synchronized boolean isStopUser() {
        return this.quiStop == 0;
    }

    public synchronized boolean isStopProg() {
        return this.quiStop == 1;
    }

    public long getElapsedTime() {
        return this.tpsTotal;
    }

    public void run() {
        long debut = 0L;
        block7: while (this.vivant) {
            switch (this.etatCrt) {
                case 1: {
                    debut = System.currentTimeMillis();
                    this.demarre();
                    this.tpsTotal = 0L;
                    this.etatPrec = 1;
                    this.etatCrt = 2;
                    this.quiStop = -1;
                    continue block7;
                }
                case 2: {
                    if (this.conditionEvolution()) {
                        this.itere();
                        long fin = System.currentTimeMillis();
                        this.tpsTotal += fin - debut;
                        debut = fin;
                        continue block7;
                    }
                    this.etatPrec = 2;
                    this.etatCrt = 4;
                    this.quiStop = 1;
                    continue block7;
                }
                case 4: {
                    this.termine();
                    if (this.etatCrt != 4) continue block7;
                    this.etatPrec = 4;
                    this.etatCrt = 0;
                    continue block7;
                }
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            debut = System.currentTimeMillis();
        }
    }

    public void stopEvolution() {
        this.vivant = false;
    }

    public static void attendre(Evolution e) throws InterruptedException {
        while (e.getEtat() != 0) {
            Thread.sleep(10L);
        }
    }

    public abstract void demarre();

    public abstract void itere();

    public abstract void termine();

    public abstract boolean conditionEvolution();
}

