/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique.ihm;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Locale;
import javalain.algorithmegenetique.EvolutionGA;
import javalain.algorithmegenetique.ihm.Aide;
import javalain.algorithmegenetique.ihm.Courbe;
import javalain.algorithmegenetique.ihm.PanneauModeEvolution;
import javalain.algorithmegenetique.ihm.SynchroCtrlAG;
import javalain.algorithmegenetique.ihm.composant.JCheckBoxMenuItemEA;
import javalain.algorithmegenetique.ihm.composant.JLabelEAPar;
import javalain.algorithmegenetique.ihm.composant.JLabelEAPres;
import javalain.algorithmegenetique.ihm.composant.JMenuEA;
import javalain.algorithmegenetique.ihm.composant.JMenuItemEA;
import javalain.algorithmegenetique.ihm.composant.JRadioButtonMenuItemEA;
import javalain.algorithmegenetique.ihm.composant.JTextFieldEA;
import javalain.algorithmegenetique.ihm.composant.TitledBorderEA;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import util.GuiUtils;

public final class ControleAlgoG
extends JFrame
implements ActionListener,
Runnable,
WindowListener {
    private static final String MI_AIDE = "Api";
    private static final String MI_TUTORIAL = "Tutorial";
    private static final String BULLE_DEMARRE = "D\u00e9marre une \u00e9volution";
    private static final String BULLE_TERMINE = "Termine l'\u00e9volution en cours";
    private static final String BULLE_REPRISE = "Reprend l'\u00e9volution";
    private static final String BULLE_PAUSE = "Suspend l'\u00e9volution en cours";
    private Container conteneur;
    private JMenuItemEA miDemarre;
    private JMenuItemEA miPause;
    private JMenuItemEA miEdition;
    private JRadioButtonMenuItemEA rbmiGGA;
    private JRadioButtonMenuItemEA rbmiSSGA;
    private JRadioButtonMenuItemEA rbmiES;
    private JRadioButtonMenuItemEA rbmiMOGA;
    private JRadioButtonMenuItemEA rbmiNPGA;
    private JRadioButtonMenuItemEA rbmiNSGA;
    private JRadioButtonMenuItemEA rbmiVEGA;
    private PanneauModeEvolution modeEvolution;
    private JPanel jpCourbe;
    private JCheckBoxMenuItemEA cbmiCourbe;
    private Courbe courbe;
    private JTextFieldEA txtNbInd = null;
    private JTextFieldEA txtNbGen = null;
    private JTextFieldEA txtTpsMoy = null;
    private JTextFieldEA txtTpsSel = null;
    private JTextFieldEA txtTpsCrois = null;
    private JTextFieldEA txtTpsMut = null;
    private JTextFieldEA txtTpsFit = null;
    private JTextFieldEA txtTpsAutre = null;
    private JTextFieldEA txtNoteMax = null;
    private JTextFieldEA txtNoteMoy = null;
    private long frequence;
    private boolean freqPause;
    private int nbInd = 0;
    private int nbGen = 0;
    private long tpsSel = 0L;
    private long tpsCrois = 0L;
    private long tpsMut = 0L;
    private long tpsFit = 0L;
    private long tpsTotal = 0L;
    private double noteMax;
    private double noteMoy;
    private EvolutionGA evolutionGA;
    private ArrayList<SynchroCtrlAG> listeSynchro = new ArrayList();
    private boolean vivant;
    private boolean marche;
    private boolean stop;

    public ControleAlgoG() {
        this(0, 0);
    }

    public ControleAlgoG(int x, int y) {
        super("Contr\u00f4le de l'\u00e9volution et des param\u00e8tres d'un algorithme g\u00e9n\u00e9tique");
        Locale.setDefault(Locale.FRANCE);
        this.setLocation(x, y);
        this.setResizable(false);
        JMenuBar menu_bar = new JMenuBar();
        JMenuEA menu = new JMenuEA("Evolution");
        menu_bar.add(menu);
        this.miDemarre = new JMenuItemEA("Demarre");
        this.miDemarre.addActionListener(this);
        this.miDemarre.setEnabled(false);
        menu.add(this.miDemarre);
        this.miPause = new JMenuItemEA("Pause");
        this.miPause.addActionListener(this);
        this.miPause.setEnabled(false);
        menu.add(this.miPause);
        menu.addSeparator();
        JMenuItemEA menu_item = new JMenuItemEA("Quitter");
        menu_item.addActionListener(this);
        menu.add(menu_item);
        menu = new JMenuEA("Algorithme");
        menu_bar.add(menu);
        ButtonGroup group = new ButtonGroup();
        menu_item = new JMenuItemEA("M\u00e9thode MonoObjectif");
        menu_item.setEnabled(true);
        this.rbmiGGA = new JRadioButtonMenuItemEA("Generational GA");
        this.rbmiGGA.setToolTipText("or Simple GA");
        this.rbmiGGA.setEnabled(false);
        this.rbmiGGA.addActionListener(this);
        group.add(this.rbmiGGA);
        menu.add(this.rbmiGGA);
        this.rbmiSSGA = new JRadioButtonMenuItemEA("Steady-State GA");
        this.rbmiSSGA.setEnabled(false);
        this.rbmiSSGA.addActionListener(this);
        group.add(this.rbmiSSGA);
        menu.add(this.rbmiSSGA);
        this.rbmiES = new JRadioButtonMenuItemEA("Evolution Strategy");
        this.rbmiES.setEnabled(false);
        this.rbmiES.addActionListener(this);
        group.add(this.rbmiES);
        menu.addSeparator();
        menu_item = new JMenuItemEA("M\u00e9thode MultiObjectif");
        menu_item.setEnabled(true);
        menu.add(menu_item);
        this.rbmiMOGA = new JRadioButtonMenuItemEA("MultiObjective GA");
        this.rbmiMOGA.setEnabled(false);
        this.rbmiMOGA.addActionListener(this);
        group.add(this.rbmiMOGA);
        this.rbmiNPGA = new JRadioButtonMenuItemEA("Niched Pareto GA");
        this.rbmiNPGA.setEnabled(false);
        this.rbmiNPGA.addActionListener(this);
        group.add(this.rbmiNPGA);
        this.rbmiNSGA = new JRadioButtonMenuItemEA("Nondominated Sorting GA 2");
        this.rbmiNSGA.setEnabled(true);
        this.rbmiNSGA.addActionListener(this);
        group.add(this.rbmiNSGA);
        menu.add(this.rbmiNSGA);
        this.rbmiVEGA = new JRadioButtonMenuItemEA("Vector Evaluated GA");
        this.rbmiVEGA.setEnabled(false);
        this.rbmiVEGA.addActionListener(this);
        group.add(this.rbmiVEGA);
        menu = new JMenuEA("Affichage");
        menu_bar.add(menu);
        this.miEdition = new JMenuItemEA("Edition");
        this.miEdition.addActionListener(this);
        this.miEdition.setEnabled(false);
        menu.add(this.miEdition);
        menu.addSeparator();
        JMenuEA smenu = new JMenuEA("Fr\u00e9quence");
        menu.add(smenu);
        group = new ButtonGroup();
        JRadioButtonMenuItemEA rb_item = new JRadioButtonMenuItemEA("Haute");
        rb_item.setToolTipText("250 ms");
        rb_item.addActionListener(this);
        group.add(rb_item);
        smenu.add(rb_item);
        rb_item = new JRadioButtonMenuItemEA("Normale");
        rb_item.setToolTipText("500 ms");
        rb_item.addActionListener(this);
        group.add(rb_item);
        smenu.add(rb_item);
        rb_item.setSelected(true);
        this.frequence = 500L;
        this.freqPause = false;
        rb_item = new JRadioButtonMenuItemEA("Basse");
        rb_item.setToolTipText("1000 ms");
        rb_item.addActionListener(this);
        group.add(rb_item);
        smenu.add(rb_item);
        rb_item = new JRadioButtonMenuItemEA("En pause");
        rb_item.addActionListener(this);
        group.add(rb_item);
        smenu.add(rb_item);
        menu.addSeparator();
        this.cbmiCourbe = new JCheckBoxMenuItemEA("Courbe");
        this.cbmiCourbe.setEnabled(false);
        this.cbmiCourbe.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (ControleAlgoG.this.cbmiCourbe.isSelected()) {
                    ControleAlgoG.this.conteneur.add(ControleAlgoG.this.jpCourbe);
                } else {
                    ControleAlgoG.this.conteneur.remove(ControleAlgoG.this.jpCourbe);
                }
                ControleAlgoG.this.pack();
            }
        });
        menu.add(this.cbmiCourbe);
        menu = new JMenuEA("?");
        menu_item = new JMenuItemEA(MI_AIDE);
        menu_item.addActionListener(this);
        menu_item = new JMenuItemEA(MI_TUTORIAL);
        menu_item.addActionListener(this);
        this.setJMenuBar(menu_bar);
        this.conteneur = this.getContentPane();
        this.conteneur.setLayout(new BoxLayout(this.conteneur, 1));
        this.modeEvolution = new PanneauModeEvolution(this);
        JPanel jp_haut = new JPanel();
        jp_haut.setLayout(new BoxLayout(jp_haut, 0));
        jp_haut.add(this.modeEvolution);
        JPanel jp_stat = new JPanel();
        TitledBorderEA tb = new TitledBorderEA("Statistiques");
        jp_stat.setBorder(tb);
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        jp_stat.setLayout(gb);
        int ligne = 0;
        JLabel lb = new JLabelEAPar("Nb d'individus");
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.gridwidth = 1;
        gbc.insets = GuiUtils.INSETS_0000;
        gbc.anchor = 17;
        gb.setConstraints(lb, gbc);
        jp_stat.add(lb);
        this.txtNbInd = new JTextFieldEA(5);
        gbc.gridx = 1;
        gbc.insets = GuiUtils.INSETS_0500;
        gb.setConstraints(this.txtNbInd, gbc);
        jp_stat.add(this.txtNbInd);
        lb = new JLabelEAPar("G\u00e9n\u00e9ration n\u00b0");
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_5000;
        gb.setConstraints(lb, gbc);
        jp_stat.add(lb);
        this.txtNbGen = new JTextFieldEA(5);
        gbc.gridx = 1;
        gbc.insets = GuiUtils.INSETS_5500;
        gb.setConstraints(this.txtNbGen, gbc);
        jp_stat.add(this.txtNbGen);
        lb = new JLabelEAPar("Temps moyen");
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_5000;
        gb.setConstraints(lb, gbc);
        jp_stat.add(lb);
        this.txtTpsMoy = new JTextFieldEA(5);
        gbc.gridx = 1;
        gbc.insets = GuiUtils.INSETS_5500;
        gb.setConstraints(this.txtTpsMoy, gbc);
        jp_stat.add(this.txtTpsMoy);
        lb = new JLabelEAPar("ms");
        gbc.gridx = 2;
        gb.setConstraints(lb, gbc);
        jp_stat.add(lb);
        lb = new JLabelEAPar("Note maximale");
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.insets = GuiUtils.INSETS_5000;
        gb.setConstraints(lb, gbc);
        jp_stat.add(lb);
        this.txtNoteMax = new JTextFieldEA(8);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.insets = GuiUtils.INSETS_5500;
        gb.setConstraints(this.txtNoteMax, gbc);
        jp_stat.add(this.txtNoteMax);
        lb = new JLabelEAPar("Note moyenne");
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.gridwidth = 1;
        gbc.insets = GuiUtils.INSETS_5000;
        gb.setConstraints(lb, gbc);
        jp_stat.add(lb);
        this.txtNoteMoy = new JTextFieldEA(8);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.insets = GuiUtils.INSETS_5500;
        gb.setConstraints(this.txtNoteMoy, gbc);
        jp_stat.add(this.txtNoteMoy);
        lb = new JLabelEAPres("R\u00e9partition CPU (%)");
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.gridwidth = 3;
        gbc.insets = GuiUtils.INSETS_5000;
        gb.setConstraints(lb, gbc);
        jp_stat.add(lb);
        lb = new JLabelEAPar("S\u00e9lection");
        gbc.gridy = ligne++;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.insets = GuiUtils.INSETS_5500;
        gb.setConstraints(lb, gbc);
        jp_stat.add(lb);
        this.txtTpsSel = new JTextFieldEA(5);
        gbc.gridx = 1;
        gbc.anchor = 17;
        gb.setConstraints(this.txtTpsSel, gbc);
        jp_stat.add(this.txtTpsSel);
        lb = new JLabelEAPar("Croisement");
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.anchor = 13;
        gb.setConstraints(lb, gbc);
        jp_stat.add(lb);
        this.txtTpsCrois = new JTextFieldEA(5);
        gbc.gridx = 1;
        gbc.anchor = 17;
        gb.setConstraints(this.txtTpsCrois, gbc);
        jp_stat.add(this.txtTpsCrois);
        lb = new JLabelEAPar("Mutation");
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.anchor = 13;
        gb.setConstraints(lb, gbc);
        jp_stat.add(lb);
        this.txtTpsMut = new JTextFieldEA(5);
        gbc.gridx = 1;
        gbc.anchor = 17;
        gb.setConstraints(this.txtTpsMut, gbc);
        jp_stat.add(this.txtTpsMut);
        lb = new JLabelEAPar("Notation");
        gbc.gridx = 0;
        gbc.gridy = ligne++;
        gbc.anchor = 13;
        gb.setConstraints(lb, gbc);
        jp_stat.add(lb);
        this.txtTpsFit = new JTextFieldEA(5);
        gbc.gridx = 1;
        gbc.anchor = 17;
        gb.setConstraints(this.txtTpsFit, gbc);
        jp_stat.add(this.txtTpsFit);
        lb = new JLabelEAPar("Autre");
        gbc.gridx = 0;
        gbc.gridy = ligne;
        gbc.anchor = 13;
        gb.setConstraints(lb, gbc);
        jp_stat.add(lb);
        this.txtTpsAutre = new JTextFieldEA(5);
        gbc.gridx = 1;
        gbc.anchor = 17;
        gb.setConstraints(this.txtTpsAutre, gbc);
        jp_stat.add(this.txtTpsAutre);
        jp_haut.add(jp_stat);
        this.conteneur.add(jp_haut);
        tb = new TitledBorderEA("Courbe");
        tb.setTitlePosition(1);
        this.jpCourbe = new JPanel();
        this.jpCourbe.setBorder(tb);
        this.jpCourbe.setLayout(new BoxLayout(this.jpCourbe, 1));
        this.courbe = new Courbe((int)jp_haut.getPreferredSize().getWidth() - 11, 100);
        this.jpCourbe.add(this.courbe);
        this.addWindowListener(this);
        this.pack();
        this.setVisible(true);
        Thread th = new Thread(this);
        this.vivant = true;
        this.marche = false;
        this.stop = true;
        th.start();
    }

    public void setEvolution(EvolutionGA e) {
        this.evolutionGA = e;
        this.rbmiGGA.setEnabled(true);
        this.rbmiSSGA.setEnabled(true);
        if (this.evolutionGA.getPopulation().getParent().getNbObjectif() > 1) {
            this.rbmiMOGA.setEnabled(true);
            this.rbmiNPGA.setEnabled(true);
            this.rbmiVEGA.setEnabled(true);
        }
        this.miEdition.setEnabled(true);
        this.updateEtatEvolution();
        this.updateParametreAG();
    }

    public EvolutionGA getEvolution() {
        return this.evolutionGA;
    }

    public void updateParametreAG() {
        String algo = this.evolutionGA.getPopulation().getParametreAG().getAlgorithme();
        if (algo.equals("Generational GA")) {
            this.rbmiGGA.setSelected(true);
            this.cbmiCourbe.setEnabled(true);
        }
        if (algo.equals("Steady-State GA")) {
            this.rbmiSSGA.setSelected(true);
            this.cbmiCourbe.setEnabled(true);
        }
        if (algo.equals("Evolution Strategy")) {
            this.rbmiES.setSelected(true);
            this.cbmiCourbe.setEnabled(true);
        }
        if (algo.equals("MultiObjective GA")) {
            this.rbmiMOGA.setSelected(true);
            this.cbmiCourbe.setSelected(false);
            this.cbmiCourbe.setEnabled(false);
        }
        if (algo.equals("Niched Pareto GA")) {
            this.rbmiNPGA.setSelected(true);
            this.cbmiCourbe.setSelected(false);
            this.cbmiCourbe.setEnabled(false);
        }
        if (algo.equals("Nondominated Sorting GA 2")) {
            this.rbmiNSGA.setSelected(true);
            this.cbmiCourbe.setSelected(false);
            this.cbmiCourbe.setEnabled(false);
        }
        if (algo.equals("Vector Evaluated GA")) {
            this.rbmiVEGA.setSelected(true);
            this.cbmiCourbe.setSelected(false);
            this.cbmiCourbe.setEnabled(false);
        }
        this.modeEvolution.setAlgorithme(algo);
    }

    public void updateEtatEvolution() {
        switch (this.evolutionGA.getEtat()) {
            case 0: {
                this.miDemarre.setText("Demarre");
                this.miDemarre.setAccelerator(KeyStroke.getKeyStroke(68, 8));
                this.miDemarre.setEnabled(true);
                this.miDemarre.setToolTipText(BULLE_DEMARRE);
                this.miPause.setText("Pause");
                this.miPause.setAccelerator(KeyStroke.getKeyStroke(80, 8));
                this.miPause.setEnabled(false);
                this.miPause.setToolTipText(BULLE_PAUSE);
                break;
            }
            case 1: {
                this.miDemarre.setText("Termine");
                this.miDemarre.setAccelerator(KeyStroke.getKeyStroke(84, 8));
                this.miDemarre.setEnabled(true);
                this.miDemarre.setToolTipText(BULLE_TERMINE);
                this.miPause.setText("Pause");
                this.miPause.setAccelerator(KeyStroke.getKeyStroke(80, 8));
                this.miPause.setEnabled(true);
                this.miPause.setToolTipText(BULLE_PAUSE);
                break;
            }
            case 2: {
                this.miPause.setText("Reprise");
                this.miPause.setAccelerator(KeyStroke.getKeyStroke(82, 8));
                this.miPause.setEnabled(true);
                this.miPause.setToolTipText(BULLE_REPRISE);
                break;
            }
        }
    }

    public void setStatCpu(long s, long c, long m, long f, long t) {
        this.tpsSel = s;
        this.tpsCrois = c;
        this.tpsMut = m;
        this.tpsFit = f;
        this.tpsTotal = t;
    }

    public void setNbIndividu(int nb) {
        this.nbInd = nb;
    }

    public void setNbGeneration(int nb) {
        this.nbGen = nb;
    }

    public void setNoteMax(double d) {
        this.noteMax = d;
        this.courbe.addNombre((float)d);
    }

    public void setNoteMoyenne(double d) {
        this.noteMoy = d;
    }

    public void run() {
        while (this.vivant) {
            try {
                Thread.sleep(this.frequence);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!this.marche || this.freqPause || this.nbGen == 0) continue;
            this.txtNbInd.setText(Integer.toString(this.nbInd));
            this.txtNbGen.setText(Integer.toString(this.nbGen));
            this.txtTpsMoy.setText(Long.toString(this.tpsTotal / (long)this.nbGen));
            double d = 100.0 / (double)this.tpsTotal;
            this.txtTpsSel.setText(GuiUtils.POURCENTAGE.format((double)this.tpsSel * d));
            this.txtTpsCrois.setText(GuiUtils.POURCENTAGE.format((double)this.tpsCrois * d));
            this.txtTpsMut.setText(GuiUtils.POURCENTAGE.format((double)this.tpsMut * d));
            this.txtTpsFit.setText(GuiUtils.POURCENTAGE.format((double)this.tpsFit * d));
            this.txtTpsAutre.setText(GuiUtils.POURCENTAGE.format((double)(this.tpsTotal - this.tpsSel - this.tpsCrois - this.tpsMut - this.tpsFit) * d));
            this.txtNoteMax.setText(GuiUtils.SCIENTIFIQUE.format(this.noteMax));
            this.txtNoteMoy.setText(GuiUtils.SCIENTIFIQUE.format(this.noteMoy));
            this.courbe.repaint();
            for (int i = 0; i < this.listeSynchro.size(); ++i) {
                this.listeSynchro.get(i).synchroniseCtrlAG();
            }
            if (!this.stop) continue;
            this.marche = false;
        }
    }

    public void demarre() {
        this.stop = false;
        this.marche = true;
        this.courbe.raz();
    }

    public void termine() {
        this.stop = true;
    }

    public void stop() {
        this.vivant = false;
        this.miDemarre.setText("Demarre");
        this.miDemarre.setEnabled(false);
        this.miDemarre.setToolTipText(null);
        this.miPause.setText("Pause");
        this.miPause.setEnabled(false);
        this.miPause.setToolTipText(null);
    }

    public void addSynchroCtrlAG(SynchroCtrlAG scag) {
        this.listeSynchro.add(scag);
    }

    public void actionPerformed(ActionEvent e) {
        String cde = e.getActionCommand();
        if (cde == "Demarre") {
            this.evolutionGA.setEtat(5);
        }
        if (cde == "Termine") {
            this.evolutionGA.setEtat(6);
        }
        if (cde == "Reprise") {
            this.evolutionGA.setEtat(1);
        }
        if (cde == "Pause") {
            this.evolutionGA.setEtat(2);
        }
        if (cde.equals("Generational GA") || cde.equals("Steady-State GA") || cde.equals("Evolution Strategy")) {
            this.cbmiCourbe.setEnabled(true);
            this.getEvolution().getPopulation().getParametreAG().setAlgorithme(e.getActionCommand());
            this.modeEvolution.setAlgorithme(cde);
        }
        if (cde.equals("MultiObjective GA") || cde.equals("Niched Pareto GA") || cde.equals("Nondominated Sorting GA 2") || cde.equals("Vector Evaluated GA")) {
            this.cbmiCourbe.setSelected(false);
            this.cbmiCourbe.setEnabled(false);
            this.getEvolution().getPopulation().getParametreAG().setAlgorithme(e.getActionCommand());
            this.modeEvolution.setAlgorithme(cde);
        }
        if (cde == "Haute") {
            this.freqPause = false;
            this.frequence = 250L;
        }
        if (cde == "Normale") {
            this.freqPause = false;
            this.frequence = 500L;
        }
        if (cde == "Basse") {
            this.freqPause = false;
            this.frequence = 1000L;
        }
        if (cde == "En pause") {
            this.freqPause = true;
            this.frequence = 250L;
        }
        if (cde == "Quitter") {
            System.exit(0);
        }
        if (cde == "Edition") {
            System.out.print(this.evolutionGA.getPopulation().getParametreAG());
        }
        if (cde == MI_TUTORIAL) {
            JOptionPane.showMessageDialog(this, "A faire !", MI_TUTORIAL, 1);
        }
        if (cde == MI_AIDE) {
            try {
                new Aide();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Aide introuvable !", "Erreur", 0);
            }
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

