% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{REIDS_Analysis}
\alias{REIDS_Analysis}
\title{REIDS_Analysis}
\usage{
REIDS_Analysis(geneIDs, Indices, DataFile, nsim = 5000,
  informativeCalls = FALSE, Summarize = TRUE, rho = 0.5,
  Exonthreshold = 0.5, significancelevel = 0.05, Groups, paired = FALSE,
  Low_AllSamples = c(), Low_GSamples = c(), Juninfo = "User",
  JAnnotI = NULL, JAnnot = NULL, EandTrAnnotI = NULL,
  EandTrAnnot = NULL, PartiallyAnnotated = FALSE, positionData = NULL,
  transcriptData = NULL, Location = "Output", Name = "REIDSAnalysis")
}
\arguments{
\item{geneIDs}{A vector with the geneIDs to analyze.}

\item{Indices}{The .csv file created by Line_Indexer.py which contains indices for every gene.}

\item{DataFile}{The .csv file created by PivotTransformation.}

\item{nsim}{The number of iterations to perform. Defaults to 1000.}

\item{informativeCalls}{Logical. Should the I/NI calls method be perform before applying the REIDS model?}

\item{Summarize}{A character vector specifying the wich summarization method to be performed. The choices are using "EqualAll", "WeightedAll", "EqualConst", "WeightedConst". The former two use all probe sets while the latter to use only the consituitive probe sets. Summarization on the consistuitive probe sets will only be performed if ASPSR is specified.}

\item{rho}{The threshold for filtering in the I/NI calls method. Probesets with scores higher than rho are kept.}

\item{Exonthreshold}{The exon score threshold to be maintained. If not NULL, probesets with an exon score lower than this value are not considered further and the p-values will be adjusted for multiplicity after testing. If NULL, all probesets are considered and a multiplicity correction is not performed.}

\item{significancelevel}{The significance level to be maintained on the p-values. The filtering on the significance is conducted only if an Exonthreshold is specified and the p-value are adjusted for multiplicity.}

\item{Groups}{A list with elements specifying the columns of the data in each group.}

\item{paired}{Logical. Are the groups paired? If TRUE the mean paired differences are calculated and tested whether these are significantly different from zero or not.}

\item{Low_AllSamples}{A character vector containing the probe sets which are not DABG in all samples.}

\item{Low_GSamples}{A list with a  character vector per group containing the probe sets which are not DABG in that group.}

\item{Juninfo}{A parameter specifying wether the annotations are user of Ensembl defined. If JunInfo is "User" (default) the annotations provided in EandTrAnnot are used. If JunInfo is "Ensembl" the annotations in EandTrAnnot are used to set up tje junction associations but the gene name and position in transcriptData and positionData are used to connect with the Ensembl data base and retrieve corresponding information.}

\item{JAnnotI}{The file name with line indices for the junction associations.}

\item{JAnnot}{The file name with the junction associations.}

\item{EandTrAnnotI}{The file name with line indices for the exon and isoform annotations.}

\item{EandTrAnnot}{The file name with the exon and isoform annotations.}

\item{PartiallyAnnotated}{Logical. Should the exon annotations with partially annotated probe sets still be included? If FALSE, these are excluded. If TRUE, these are included. Default is FALSE.}

\item{positionData}{The file with the chromosome start and ends for the probe sets. Only needed in JunInfo=Ensembl.}

\item{transcriptData}{The file with gene name of the transcripts. Only needed in JunInfo=Ensembl.}

\item{Location}{A character string indication the place where the outputs are saved. Defaults to Output.}

\item{Name}{A character string with the name of the ouput file. Defaults to "REIDSAnalysis".}
}
\value{
The output will be written to each of the corresponding .txt files of the called upon functions.
}
\description{
The REIDS_Analysis is a wrapper function for the REIDSFunction, the ASExon function, the REIDS_JunctionAssesment function and the REIDS_IsoformAssesment function.
}
\examples{
\dontrun{
data(TC1500264)
PivotTransformData(Data=TC1500264,GeneID=NULL,ExonID=NULL,
REMAPSplitFile="TC1500264_Gene_SplitFile.txt",Location="Output/",Name="TC1500264_Pivot")

REIDS_Analysis(Indices="Output/TC1500264_LineIndex.csv",DataFile="Output/TC1500264_Pivot.csv",
nsim=100,informativeCalls=FALSE,Summarize=c("WeightedAll","EqualAll","WeightedConst","EqualConst"),
rho=0.5,Exonthreshold=0.5,significancelevel=0.05,Groups=Groups,paired=FALSE,Low_AllSamples=c()
,Low_GSamples=c(),Juninfo="User",JAnnotI=NULL,JAnnot=NULL,EandTrAnnotI="Output/REMAP_Indices.txt",
EandTrAnnot="Output/HJAY_REMAP.txt",positionData=NULL,transcriptData=NULL,
Location="OutputREIDSAnalysis",Name="TC1500264")
}
}
