% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{JunInfo}
\alias{JunInfo}
\title{JunInfo}
\usage{
JunInfo(file_name, file_pos, line_length, ASPSR = c(), Juninfo = "User",
  JAnnotI, JAnnot = NULL, EandTrAnnotI = NULL, EandTrAnnot = NULL,
  PartiallyAnnotated = FALSE, positionData = NULL, transcriptData = NULL,
  Groups = list(), Low_AllSamples = c(), Low_GSamples = c(),
  Plot = FALSE, Location = NULL, Name = "")
}
\arguments{
\item{file_name}{The name of the pivot transformed .csv file.}

\item{file_pos}{The position in the file where to start reading.}

\item{line_length}{The length of the line to read.}

\item{ASPSR}{The AS probe sets as identified by ASExons.}

\item{Juninfo}{A parameter specifying wether the annotations are user of Ensembl defined. If JunInfo is "User" (default) the annotations provided in EandTrAnnot are used. If JunInfo is "Ensembl" the annotations in EandTrAnnot are used to set up tje junction associations but the gene name and position in transcriptData and positionData are used to connect with the Ensembl data base and retrieve corresponding information.}

\item{JAnnotI}{The file name with line indices for the junction associations.}

\item{JAnnot}{The file name with the junction associations.}

\item{EandTrAnnotI}{The file name with line indices for the exon and isoform annotations.}

\item{EandTrAnnot}{The file name with the exon and isoform annotations.}

\item{PartiallyAnnotated}{Logical. Should the exon annotations with partially annotated probe sets still be included? If FALSE, these are excluded. If TRUE, these are included. Default is FALSE.}

\item{positionData}{The file with the chromosome start and ends for the probe sets. Only needed in JunInfo=Ensembl.}

\item{transcriptData}{The file with gene name of the transcripts. Only needed in JunInfo=Ensembl.}

\item{Groups}{A list with  elements speficifing the columns of the data in each group.}

\item{Low_AllSamples}{A character vector containing the probe sets which are not DABG in all samples.}

\item{Low_GSamples}{A list with a  character vector per group containing the probe sets which are not DABG in that group.}

\item{Plot}{Should a plot of the gene model be made?}

\item{Location}{A character string indication the place where the outputs are saved.}

\item{Name}{A character string with the name of the ouput file.}
}
\value{
The function returns four files. The first file has name "Name_ASInfo.txt" and contains a line per probe set. It shows the reached decision regarding the probe set (Const/AS/not DABG),its linking and exclusion junctions, the fold change, the AS type and its annotated exons. The second file, "Name_Compositions.txt", is a list of all found transcripts for a particular TC ID. The third file,"Name_GroupTranscripts.txt" indicates whether a specific transcript is present or absent in a group. The fourth file "Name_NovelConnections.txt" contains junctions which are showing an undocumented connection between probe sets.
}
\description{
JunInfo functions asses the junction information for a single gene
}
\details{
The plot is produced by the arcplot function of the arcdiagram package (https://github.com/gastonstat/arcdiagram)
}
