% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cbound.R
\name{RDSmoothnessBound}
\alias{RDSmoothnessBound}
\title{Lower bound on smoothness constant M in sharp RD designs}
\usage{
RDSmoothnessBound(
  object,
  s,
  separate = FALSE,
  multiple = TRUE,
  alpha = 0.05,
  sclass = "H"
)
}
\arguments{
\item{object}{An object of class \code{"RDResults"}, typically a result of a
call to \code{\link{RDHonest}}.}

\item{s}{Number of support points that curvature estimates should average
over.}

\item{separate}{If \code{TRUE}, report estimates separately for data above
and below cutoff. If \code{FALSE}, report pooled estimates.}

\item{multiple}{If \code{TRUE}, use multiple curvature estimates. If
\code{FALSE}, only use a single curvature estimate using observations
closest to the cutoff.}

\item{alpha}{determines confidence level \code{1-alpha}.}

\item{sclass}{Smoothness class, either \code{"T"} for Taylor or \code{"H"}
for Hölder class.}
}
\value{
Returns a data frame wit the following columns:

\describe{
\item{\code{estimate}}{Point estimate for lower bounds for M. }

\item{\code{conf.low}}{Lower endpoint for a one-sided confidence interval
                       for M}

}

The data frame has a single row if \code{separate==FALSE}; otherwise it has
two rows, corresponding to smoothness bound estimates and confidence
intervals below and above the cutoff, respectively.
}
\description{
Estimate a lower bound on the smoothness constant M and provide a lower
confidence interval for it, using method described in supplement to
Kolesár and Rothe (2018).
}
\examples{
## Subset data to increase speed
r <- RDHonest(log(earnings)~yearat14, data=cghs,
              subset=abs(yearat14-1947)<10,
              cutoff=1947, M=0.04, h=3)
RDSmoothnessBound(r, s=2)
}
\references{
{

\cite{Michal Kolesár and Christoph Rothe. Inference in regression
      discontinuity designs with a discrete running variable.
      American Economic Review, 108(8):2277—-2304,
      August 2018. \doi{10.1257/aer.20160945}}

}
}
