% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{OF_vectorized3}
\alias{OF_vectorized3}
\title{Calculates objective function for the classical algorithm: used in iterate() and in local_search.}
\usage{
OF_vectorized3(
  NN,
  TT,
  g,
  grid,
  Y,
  beta_est,
  lc,
  fc,
  lg,
  fg,
  S,
  k,
  kg,
  method_estimate_beta,
  num_factors_may_vary = TRUE
)
}
\arguments{
\item{NN}{number of time series}

\item{TT}{length of time series}

\item{g}{Vector with group membership for all individuals}

\item{grid}{dataframe containing the matrix multiplications XB, FgLg and FL}

\item{Y}{Y: NxT dataframe with the panel data of interest}

\item{beta_est}{estimated values of beta}

\item{lc}{loadings of estimated common factors}

\item{fc}{estimated common factors}

\item{lg}{estimated grouploadings}

\item{fg}{estimated groupfactors}

\item{S}{number of estimated groups}

\item{k}{number of common factors to be estimated}

\item{kg}{number of group specific factors to be estimated}

\item{method_estimate_beta}{defines how beta is estimated. Default case is an estimated beta for each individual. Default value is "individual." Possible values are "homogeneous", "group" or "individual".}

\item{num_factors_may_vary}{whether or not the number of groupfactors is constant over all groups or not}
}
\value{
numeric value of the objective function
}
\description{
Calculates objective function for the classical algorithm: used in iterate() and in local_search.
}
